/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5294;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import xaero.common.HudMod;
import xaero.common.file.SimpleBackup;
import xaero.common.minimap.waypoints.WaypointDimensionTypeInfo;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.world.connection.MinimapWorldConnectionManager;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.config.RootConfig;
import xaero.hud.path.XaeroPath;

public class MinimapWorldRootContainer
extends WaypointWorldContainer {
    private final RootConfig config;
    private final Map<class_5321<class_1937>, WaypointDimensionTypeInfo> dimensionTypes;

    protected MinimapWorldRootContainer(HudMod modMain, MinimapSession session, XaeroPath path) {
        super(modMain, session, path, null);
        this.config = new RootConfig(MinimapWorldContainerUtil.isMultiplayer(path));
        this.dimensionTypes = new HashMap<class_5321<class_1937>, WaypointDimensionTypeInfo>();
    }

    public void updateConnectionsField(WaypointSession session) {
        this.config.resetSubWorldConnections(MinimapWorldContainerUtil.isMultiplayer(this.path));
    }

    public MinimapWorldConnectionManager getSubWorldConnections() {
        return this.config.getSubWorldConnections();
    }

    public WaypointDimensionTypeInfo getDimensionType(class_5321<class_1937> dimId) {
        WaypointDimensionTypeInfo dimensionType = this.dimensionTypes.get(dimId);
        if (dimensionType != null) {
            return dimensionType;
        }
        if (dimId == class_1937.field_25180) {
            dimensionType = new WaypointDimensionTypeInfo(class_2874.field_26753.toString().replace(':', '$'), false, 0.1f, 256, 128, true, false, false, 0.5f, 8.0, false);
        } else if (dimId == class_1937.field_25179) {
            dimensionType = new WaypointDimensionTypeInfo(class_2874.field_26752.toString().replace(':', '$'), true, 0.0f, 256, 256, false, true, false, 0.0f, 1.0, false);
        } else if (dimId == class_1937.field_25181) {
            dimensionType = new WaypointDimensionTypeInfo(class_2874.field_26754.toString().replace(':', '$'), false, 0.0f, 256, 256, false, false, true, 0.0f, 1.0, true);
        } else {
            class_1132 integratedServer = class_310.method_1551().method_1576();
            if (integratedServer == null) {
                return null;
            }
            class_3218 serverLevel = integratedServer.method_3847(dimId);
            if (serverLevel == null) {
                return null;
            }
            dimensionType = this.getDimTypeInfo(serverLevel.method_8597());
        }
        this.dimensionTypes.put(dimId, dimensionType);
        return dimensionType;
    }

    public double getDimensionScale(class_5321<class_1937> dimId) {
        WaypointDimensionTypeInfo dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.getCoordinateScale();
    }

    public void updateDimensionType(class_638 level) {
        WaypointDimensionTypeInfo currentDimType;
        class_5321 dimId = level.method_27983();
        WaypointDimensionTypeInfo newDimType = this.getDimTypeInfo(level.method_8597());
        if (Objects.equals(newDimType, currentDimType = this.dimensionTypes.get(dimId))) {
            return;
        }
        this.dimensionTypes.put((class_5321<class_1937>)dimId, newDimType);
        this.session.getWorldManagerIO().getRootConfigIO().save(this);
    }

    public void renameOldContainer(XaeroPath containerPath) {
        if (this.subContainers.isEmpty()) {
            return;
        }
        String dimensionPart = containerPath.getAtIndex(1).getLastNode();
        if (this.subContainers.containsKey(dimensionPart)) {
            return;
        }
        class_5321<class_1937> dimId = this.session.getDimensionHelper().getDimensionKeyForDirectoryName(dimensionPart);
        if (dimId == null) {
            return;
        }
        class_2960 dimKey = dimId.method_29177();
        String dimKeyOldValidation = dimKey.method_12832().replaceAll("[^a-zA-Z0-9_]+", "");
        XaeroPath customWorldPath = this.session.getWorldState().getCustomWorldPath();
        MinimapWorldContainer currentCustomContainer = customWorldPath == null ? null : this.session.getWorldManager().getWorld(customWorldPath).getContainer();
        for (Map.Entry subContainerEntry : this.subContainers.entrySet()) {
            String subKey = (String)subContainerEntry.getKey();
            if (!subKey.equals(dimKeyOldValidation)) continue;
            MinimapWorldContainer dimContainer = (MinimapWorldContainer)subContainerEntry.getValue();
            boolean currentlySelected = currentCustomContainer != null && currentCustomContainer.getPath().isSubOf(dimContainer.getPath());
            this.subContainers.put(dimensionPart, dimContainer);
            this.subContainers.remove(subKey);
            SimpleBackup.moveToBackup(dimContainer.getDirectoryPath());
            dimContainer.setPath(this.path.resolve(dimensionPart));
            if (currentlySelected) {
                this.session.getWorldState().setCustomWorldPath(dimContainer.getPath().resolve(customWorldPath.getSubPath(2)));
            }
            try {
                this.session.getWorldManagerIO().saveWorlds(this);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to rename a dimension! Can't continue.", e);
            }
            MinimapWorldConnectionManager connections = this.getSubWorldConnections();
            connections.renameDimension(subKey, dimensionPart);
            this.session.getWorldManagerIO().getRootConfigIO().save(this);
            return;
        }
    }

    public Iterable<Map.Entry<class_5321<class_1937>, WaypointDimensionTypeInfo>> getDimensionTypes() {
        return this.dimensionTypes.entrySet();
    }

    public void setDimensionType(class_5321<class_1937> dim, WaypointDimensionTypeInfo dimType) {
        this.dimensionTypes.put(dim, dimType);
    }

    @Override
    public MinimapWorldRootContainer getRoot() {
        return this;
    }

    public boolean isConfigLoaded() {
        return this.config.isLoaded();
    }

    public RootConfig getConfig() {
        return this.config;
    }

    @Deprecated
    public boolean isUsingMultiworldDetection() {
        return this.config.isUsingMultiworldDetection();
    }

    @Deprecated
    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.config.setUsingMultiworldDetection(usingMultiworldDetection);
    }

    @Deprecated
    public String getDefaultMultiworldId() {
        return this.config.getDefaultMultiworldId();
    }

    @Deprecated
    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.config.setDefaultMultiworldId(defaultMultiworldId);
    }

    @Deprecated
    public boolean isTeleportationEnabled() {
        return this.config.isTeleportationEnabled();
    }

    @Deprecated
    public void setTeleportationEnabled(boolean teleportation) {
        this.config.setTeleportationEnabled(teleportation);
    }

    @Deprecated
    public boolean isUsingDefaultTeleportCommand() {
        return this.config.isUsingDefaultTeleportCommand();
    }

    @Deprecated
    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.config.setUsingDefaultTeleportCommand(usingDefaultTeleportCommand);
    }

    @Deprecated
    public String getServerTeleportCommandFormat() {
        return this.config.getServerTeleportCommandFormat();
    }

    @Deprecated
    public String getServerTeleportCommandRotationFormat() {
        return this.config.getServerTeleportCommandRotationFormat();
    }

    @Deprecated
    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.config.setServerTeleportCommandFormat(serverTeleportCommandFormat);
    }

    @Deprecated
    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.config.setServerTeleportCommandRotationFormat(serverTeleportCommandRotationFormat);
    }

    @Deprecated
    public WaypointsSort getSortType() {
        return this.config.getSortType();
    }

    @Deprecated
    public void setSortType(WaypointsSort sortType) {
        this.config.setSortType(sortType);
    }

    @Deprecated
    public void toggleSortType() {
        this.config.toggleSortType();
    }

    @Deprecated
    public boolean isSortReversed() {
        return this.config.isSortReversed();
    }

    @Deprecated
    public void setSortReversed(boolean sortReversed) {
        this.config.setSortReversed(sortReversed);
    }

    @Deprecated
    public void toggleSortReversed() {
        this.config.toggleSortReversed();
    }

    @Deprecated
    public boolean isIgnoreServerLevelId() {
        return this.config.isIgnoreServerLevelId();
    }

    @Deprecated
    public void setIgnoreServerLevelId(boolean ignoreServerLevelId) {
        this.config.setIgnoreServerLevelId(ignoreServerLevelId);
    }

    @Deprecated
    public boolean isIgnoreHeightmaps() {
        return this.config.isIgnoreHeightmaps();
    }

    @Deprecated
    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.config.setIgnoreHeightmaps(ignoreHeightmaps);
    }

    private WaypointDimensionTypeInfo getDimTypeInfo(class_2874 dimType) {
        class_5294 effects = class_5294.method_28111((class_2874)dimType);
        return new WaypointDimensionTypeInfo(dimType.method_31181().toString().replace(':', '$'), dimType.method_12491(), dimType.method_28516(0), 256, dimType.method_29959(), dimType.method_31181().equals((Object)class_2874.field_26753), dimType.method_31181().equals((Object)class_2874.field_26752), dimType.method_31181().equals((Object)class_2874.field_26754), dimType.method_28528(6000L), dimType.method_31110(), effects.method_28114());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public String getName(String worldNode) {
        return super.getName(worldNode);
    }

    @Override
    public void removeName(String worldNode) {
        super.removeName(worldNode);
    }

    @Override
    public String getSubName() {
        return super.getSubName();
    }

    public static final class Builder {
        private HudMod modMain;
        private MinimapSession session;
        private XaeroPath path;

        private Builder() {
        }

        public Builder setDefault() {
            this.setModMain(null);
            this.setSession(null);
            this.setPath(null);
            return this;
        }

        public Builder setModMain(HudMod modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setSession(MinimapSession session) {
            this.session = session;
            return this;
        }

        public Builder setPath(XaeroPath path) {
            this.path = path;
            return this;
        }

        public MinimapWorldRootContainer build() {
            if (this.modMain == null || this.session == null || this.path == null) {
                throw new IllegalStateException();
            }
            return new WaypointWorldRootContainer(this.modMain, this.session, this.path);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

