/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.config.util;

import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xaero.common.HudMod;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.hud.gui.util.GuiUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;

public class MinimapConfigClientUtils {
    public static float getUIScale(ClientConfigManager configManager, IndexedConfigOption<Integer> option, double guiScale) {
        List validValues = option.getValidValues();
        return MinimapConfigClientUtils.getUIScale(configManager, option, (Integer)validValues.get(0), (Integer)validValues.get(validValues.size() - 1), 1.0, guiScale);
    }

    public static float getUIScale(ClientConfigManager configManager, IndexedConfigOption<Integer> option, double autoScale, double guiScale) {
        List validValues = option.getValidValues();
        return MinimapConfigClientUtils.getUIScale(configManager, option, (Integer)validValues.get(0), (Integer)validValues.get(validValues.size() - 1), autoScale, guiScale);
    }

    public static float getUIScale(ClientConfigManager configManager, ConfigOption<Integer> option, int auto, int max, double autoScale, double guiScale) {
        int configValue = (Integer)configManager.getEffective(option);
        float configBasedScale = GuiUtils.getUIScale(configValue, auto, max, guiScale);
        if (configValue == auto && autoScale != 1.0) {
            return (float)Math.ceil((double)configBasedScale * autoScale);
        }
        return configBasedScale;
    }

    public static double getWaypointsClampDepth(ClientConfigManager configManager, double fov, int height, double guiScale) {
        int baseIconScale = (int)MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.WAYPOINT_ICON_SCALE_IN_WORLD, guiScale);
        double ingameCloseScale = (Double)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_CLOSE_SCALE_IN_WORLD);
        double frameSizeAtClampDepth = ingameCloseScale * 0.02133333496749401 * (double)height / (double)baseIconScale;
        double fovMultiplier = 2.0 * Math.tan(Math.toRadians(fov / 2.0));
        return frameSizeAtClampDepth / fovMultiplier;
    }

    public static void addAutoUIScaleValueToComponent(ITextComponent component, double autoScale) {
        component.func_150253_a().add(new TextComponentString(" (" + (int)Math.ceil((double)GuiUtils.getAutoUIScale() * autoScale) + ")"));
    }

    public static void addAutoMCScaleValueToComponent(ITextComponent component) {
        component.func_150253_a().add(new TextComponentString(" (" + new ScaledResolution(Minecraft.func_71410_x()).func_78325_e() + ")"));
    }

    public static int getAutoMinimapSize(double scale) {
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int size = (int)((float)(height <= width ? height : width) / GuiUtils.getMinimapScale(HudMod.INSTANCE.getHudConfigs().getClientConfigManager(), scale));
        return Math.min(Math.max(55, 2 * size * 130 / 1080), 250);
    }

    public static int getEffectiveMinimapSize(double scale) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        int minimapSizeConfig = (Integer)configManager.getEffective(MinimapProfiledConfigOptions.SIZE);
        if (minimapSizeConfig > 0) {
            return minimapSizeConfig;
        }
        return MinimapConfigClientUtils.getAutoMinimapSize(scale);
    }

    public static boolean getEffectiveNorthLocked(int mapSize, int shape) {
        if (mapSize > 180 && shape == 0) {
            return true;
        }
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean northLockedConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.NORTH_LOCKED);
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return northLockedConfig;
        }
        return northLockedConfig || (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.KEEP_ENLARGED_UNLOCKED) == false && minimapSession.getProcessor().isEnlargedMap();
    }

    private static void changeZoomUnchecked(ClientConfigManager configManager, int direction) {
        ConfigProfile currentProfile = configManager.getCurrentProfile();
        currentProfile.set((ConfigOption)MinimapProfiledConfigOptions.ZOOM, (Object)(1 + (int)MathHelper.func_188207_b((float)((Integer)currentProfile.get((ConfigOption)MinimapProfiledConfigOptions.ZOOM) - 1 + direction), (float)5.0f)));
    }

    public static void changeZoom(int direction) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
            return;
        }
        double targetBefore = minimapSession.getProcessor().getTargetZoom();
        int attempts = 0;
        do {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
        } while (++attempts < 5 && targetBefore == minimapSession.getProcessor().getTargetZoom());
        if (attempts == 5) {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
        }
    }

    public static boolean getEffectiveSlimeChunks(MinimapSession session) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean slimeChunksConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.SLIME_CHUNKS);
        if (session == null) {
            return slimeChunksConfig;
        }
        return slimeChunksConfig && (Minecraft.func_71410_x().func_71401_C() != null || session.getWorldManager().getAutoWorld().getSlimeChunkSeed() != null);
    }

    public static Long getEffectiveSlimeChunksSeed(MinimapWorld currentWorld) {
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        if (server != null) {
            try {
                if (server.func_130014_f_().field_73011_w.getDimension() != 0) {
                    return null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
            return server.func_130014_f_().func_72905_C();
        }
        return currentWorld.getSlimeChunkSeed();
    }

    public static boolean isFairPlayForCaveMode() {
        boolean fairplay = HudMod.INSTANCE.isFairPlay();
        if (!fairplay) {
            return false;
        }
        WorldClient level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return true;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return true;
        }
        MinimapProcessor processor = session.getProcessor();
        return !processor.isConsideringNetherFairPlayMessage() || level.field_73011_w.getDimension() != -1;
    }

    public static boolean hasNoCaveModeEffect() {
        Minecraft mc = Minecraft.func_71410_x();
        return Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_CAVE_MAPS) || Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_CAVE_MAPS_HARMFUL);
    }

    public static boolean getEffectiveCaveModeAllowed() {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        if (!((Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED)).booleanValue()) {
            return false;
        }
        Set allowedDimensionsLocal = (Set)configManager.getEffective(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        Set allowedDimensionsServer = (Set)configManager.getServerSynced().getEffective(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        WorldClient level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) {
            return allowedDimensionsLocal.isEmpty() && allowedDimensionsServer.isEmpty();
        }
        int currentDimensionId = level.field_73011_w.getDimension();
        if (!allowedDimensionsLocal.isEmpty() && !allowedDimensionsLocal.contains(currentDimensionId)) {
            return false;
        }
        return allowedDimensionsServer == null || allowedDimensionsServer.isEmpty() || allowedDimensionsServer.contains(currentDimensionId);
    }
}

