/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldVertexBufferUploader;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private BufferBuilder bufferBuilder = new BufferBuilder(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            BufferBuilder bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.func_228547_a_();
            bufferBuilder.func_178977_d();
            for (Integer texture : this.texturesForDrawCalls) {
                if (texture == -1) {
                    texture = 0;
                }
                textureBinder.accept(texture);
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
                if (!hasTextureFinalizer) continue;
                textureFinalizer.run();
            }
            textureBinder.accept(0);
            this.renderType.func_228549_b_();
        }
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public BufferBuilder begin(int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.func_178977_d();
            }
            this.bufferBuilder.func_181668_a(this.renderType.func_228664_q_(), this.renderType.func_228663_p_());
            this.prevTextureId = textureId;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

