/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Supplier;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import xaero.hud.category.serialization.data.ObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataSerializer;

public class ObjectCategoryDataNbtSerializer<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataSerializer<D, CompoundNBT> {
    private final Supplier<DB> builderSupplier;

    protected ObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public CompoundNBT serialize(D data) {
        CompoundNBT resultTag = new CompoundNBT();
        resultTag.func_74778_a("n", ((ObjectCategoryData)data).getName());
        resultTag.func_74757_a("p", ((ObjectCategoryData)data).getProtection());
        CompoundNBT settingOverrides = new CompoundNBT();
        ((ObjectCategoryData)data).getSettingOverrideIterator().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof Boolean) {
                settingOverrides.func_74757_a(key, ((Boolean)value).booleanValue());
                return;
            }
            if (value instanceof Double) {
                settingOverrides.func_74780_a(key, ((Double)value).doubleValue());
                return;
            }
            if (value instanceof Integer) {
                settingOverrides.func_74768_a(key, ((Integer)value).intValue());
                return;
            }
            throw new IllegalArgumentException("Unsupported category setting type: " + value.getClass());
        });
        resultTag.func_218657_a("v", (INBT)settingOverrides);
        ListNBT subCategoriesTag = new ListNBT();
        ((ObjectCategoryData)data).getSubCategoryIterator().forEachRemaining(sub -> {
            CompoundNBT subCategoryTag = this.serialize((D)sub);
            subCategoriesTag.add((Object)subCategoryTag);
        });
        resultTag.func_218657_a("s", (INBT)subCategoriesTag);
        return resultTag;
    }

    @Override
    public final D deserialize(CompoundNBT serializedData) {
        return ((ObjectCategoryData.Builder)this.getConfiguredBuilder(serializedData)).build();
    }

    protected DB getConfiguredBuilder(CompoundNBT serializedData) {
        ObjectCategoryData.Builder builder = (ObjectCategoryData.Builder)this.builderSupplier.get();
        builder.setName(serializedData.func_74779_i("n"));
        builder.setProtection(serializedData.func_74767_n("p"));
        CompoundNBT settingOverrides = serializedData.func_74775_l("v");
        for (String key : settingOverrides.func_150296_c()) {
            INBT valueTag = settingOverrides.func_74781_a(key);
            if (valueTag instanceof ByteNBT) {
                builder.setSettingOverride(key, ((ByteNBT)valueTag).func_150290_f() == 1);
                continue;
            }
            if (valueTag instanceof DoubleNBT) {
                builder.setSettingOverride(key, ((DoubleNBT)valueTag).func_150286_g());
                continue;
            }
            if (valueTag instanceof IntNBT) {
                builder.setSettingOverride(key, ((IntNBT)valueTag).func_150287_d());
                continue;
            }
            throw new IllegalArgumentException("Unsupported category setting NBT tag type: " + valueTag.getClass());
        }
        ListNBT subCategoriesTag = serializedData.func_150295_c("s", 10);
        for (INBT subCategoryTag : subCategoriesTag) {
            builder.addSubCategoryBuilder(this.getConfiguredBuilder((CompoundNBT)subCategoryTag));
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected ObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new ObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>> {
        protected final B self = this;
        protected Supplier<DB> builderSupplier;

        protected Builder() {
        }

        public B setDefault() {
            this.setBuilderSupplier(null);
            return this.self;
        }

        public B setBuilderSupplier(Supplier<DB> builderSupplier) {
            this.builderSupplier = builderSupplier;
            return this.self;
        }

        public ObjectCategoryDataNbtSerializer<D, DB> build() {
            if (this.builderSupplier == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ObjectCategoryDataNbtSerializer<D, DB> buildInternally();
    }
}

