/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShaderHelper;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        this.drawMyTexturedModalRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f);
    }

    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        if (discardAlpha < 0.0f) {
            RenderSystem.setShader((ShaderProgram)LibShaders.POSITION_TEX_NO_ALPHA_TEST);
        } else {
            RenderSystem.setShader((ShaderProgram)LibShaders.POSITION_TEX_ALPHA_TEST);
            PositionTexAlphaTestShaderHelper.setDiscardAlpha((float)discardAlpha);
        }
        this.drawMyTexturedModalRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    public void drawIconOutline(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        PositionTexAlphaTestShaderHelper.setDiscardAlpha((float)discardAlpha);
        RenderSystem.setShader((ShaderProgram)LibShaders.POSITION_TEX_ALPHA_TEST);
        this.drawMyTexturedModalRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private void drawMyTexturedModalRectInternal(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setUv(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setUv(((float)textureX + width) * f, ((float)textureY + theight) * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setUv((float)(textureX + 0) * f, ((float)textureY + theight) * f1);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    public void prepareMyTexturedColoredModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, float r, float g, float b, float a, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(textureId);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setColor(r, g, b, a).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(r, g, b, a).setUv(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setColor(r, g, b, a).setUv(((float)textureX + width) * f, ((float)textureY + theight) * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setColor(r, g, b, a).setUv((float)(textureX + 0) * f, ((float)textureY + theight) * f1);
    }

    public void prepareMyTexturedModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(textureId);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setUv(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setUv(((float)textureX + width) * f, ((float)textureY + theight) * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setUv((float)(textureX + 0) * f, ((float)textureY + theight) * f1);
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(matrixStack, startAngle, sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i <= sides; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.addVertex(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).setUv(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1);
                vertexBuffer.addVertex(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).setUv(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1);
                vertexBuffer.addVertex(matrix, (float)centerX, (float)centerY, 0.0f).setUv(centerU, centerV);
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    void drawTexturedElipseInsideRectangleFrame(PoseStack matrixStack, boolean resetTexture, boolean reverseTexture, double startAngle, int startIndex, int endIndex, int sides, float thickness, float x, float y, int textureX, int textureY, float width, float twidth, float theight, int seamWidth, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        float prevSegmentTextureX = 0.0f;
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float outerRadius = halfWidth + thickness;
        float segmentOuterWidth = (float)(fullCircle / (double)sides * (double)outerRadius);
        startIndex = Math.max(Math.min(startIndex, sides), 0);
        endIndex = Math.max(Math.min(endIndex, sides), startIndex);
        int textureStartIndex = resetTexture ? (reverseTexture ? endIndex : startIndex) : 0;
        float seamThreshold = reverseTexture ? (float)seamWidth + segmentOuterWidth : (float)seamWidth;
        for (int i = startIndex; i <= endIndex; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)outerRadius * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)outerRadius * cos);
            float segmentTextureStartX = textureX;
            float offsetX = Math.abs(segmentOuterWidth * (float)(i - textureStartIndex));
            if (offsetX >= seamThreshold) {
                segmentTextureStartX = textureX + seamWidth;
                if ((offsetX -= seamThreshold) >= twidth) {
                    offsetX %= twidth;
                }
            }
            float segmentTextureX = segmentTextureStartX + offsetX;
            if (i > startIndex) {
                vertexBuffer.addVertex(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).setUv(prevSegmentTextureX * f, ((float)textureY + theight) * f1);
                vertexBuffer.addVertex(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).setUv(segmentTextureX * f, ((float)textureY + theight) * f1);
                vertexBuffer.addVertex(matrix, x + vertexLocalOuterX, y + vertexLocalOuterY, 0.0f).setUv(segmentTextureX * f, (float)textureY * f1);
                vertexBuffer.addVertex(matrix, x + prevVertexLocalOuterX, y + prevVertexLocalOuterY, 0.0f).setUv(prevSegmentTextureX * f, (float)textureY * f1);
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
            prevSegmentTextureX = segmentTextureX;
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    public void addTexturedRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.addVertex(matrix, x, y + (float)h, 0.0f).setUv(normalizedU1, normalizedV2);
        vertexBuffer.addVertex(matrix, x + (float)w, y + (float)h, 0.0f).setUv(normalizedU2, normalizedV2);
        vertexBuffer.addVertex(matrix, x + (float)w, y, 0.0f).setUv(normalizedU2, normalizedV1);
        vertexBuffer.addVertex(matrix, x, y, 0.0f).setUv(normalizedU1, normalizedV1);
    }

    public void drawMyColoredRect(PoseStack matrixStack, float x1, float y1, float x2, float y2) {
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    public void addColoredLineToExistingBuffer(PoseStack.Pose matrices, VertexConsumer vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.addVertex(matrices, x1, y1, 0.0f).setColor(r, g, b, a).setNormal(matrices, x2 - x1, y2 - y1, 0.0f);
        vertexBuffer.addVertex(matrices, x2, y2, 0.0f).setColor(r, g, b, a).setNormal(matrices, x2 - x1, y2 - y1, 0.0f);
    }

    public void drawMyColoredRect(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GlStateManager._bindTexture((int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
        RenderSystem.setShaderTexture((int)0, (int)par0);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho(RenderTarget framebuffer) {
        if (framebuffer != null) {
            Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)framebuffer.width, (float)framebuffer.height, 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        }
    }

    public static void restoreDefaultShaderBlendState() {
        RenderSystem.defaultBlendFunc();
    }
}

