/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import xaero.common.HudMod;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.info.config.InfoDisplayConfigData;
import xaero.hud.minimap.common.config.info.config.InfoDisplayManagerConfigData;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.InfoDisplayManager;
import xaero.hud.minimap.info.config.InfoDisplayConfigClientUtils;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.common.config.Config;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final class_2561 HELP_COMPONENT = class_2561.method_43471((String)"gui.xaero_minimap_info_display_manager_help");
    private static final class_2561 SERVER_ENFORCED_COMPONENT = class_2561.method_43471((String)"gui.xaero_info_display_editor_server_enforced").method_27692(class_124.field_1054);
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private int subSelected;
    private final Map<String, MoveableEntry<?>> moveableEntries;
    private final boolean clientSide;
    private InfoDisplayManagerConfigData inputConfig;
    private final Config config;
    private final Runnable onChange;
    private final boolean viewingEnforced;
    private boolean madeChanges;

    public GuiInfoDisplayEdit(EditConfigScreen parent, class_437 escape, Config config, Runnable onChange, boolean viewingEnforced) {
        super((class_437)parent, escape, (class_2561)class_2561.method_43471((String)"gui.xaero_minimap_info_display_manager"));
        this.config = config;
        this.onChange = onChange;
        this.clientSide = parent.getContext().isClientSide();
        this.viewingEnforced = viewingEnforced;
        this.manager = HudMod.INSTANCE.getMinimap().getInfoDisplays().getManager();
        this.inputConfig = (InfoDisplayManagerConfigData)config.get(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG);
        if (this.inputConfig == null || this.inputConfig == InfoDisplayManagerConfigData.EMPTY) {
            this.inputConfig = InfoDisplayConfigClientUtils.createDefaultConfig(this.manager, null, this.clientSide);
        }
        this.currentOrder = this.manager.adaptOrder(this.inputConfig.getOrderStream());
        this.moveableEntries = new HashMap();
        this.selected = -1;
        this.subSelected = -1;
    }

    protected void method_25426() {
        super.method_25426();
        this.selectionList = new SelectionList();
        this.method_25429((class_364)this.selectionList);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 34, 200, 20, (class_2561)class_2561.method_43469((String)"gui.done", (Object[])new Object[0]), b -> this.goBack()));
        if (this.moveableEntries.isEmpty()) {
            for (String id : this.currentOrder) {
                InfoDisplay<?> infoDisplay = this.manager.get(id);
                MoveableEntry<?> moveable = this.createEntryFor(infoDisplay);
                this.moveableEntries.put(id, moveable);
            }
        }
        this.moveableEntries.values().forEach(this::refreshEntry);
    }

    private <T> MoveableEntry<T> createEntryFor(InfoDisplay<T> infoDisplay) {
        MoveableEntry<T> moveable = new MoveableEntry<T>(infoDisplay);
        InfoDisplayConfigData infoDisplayConfig = this.inputConfig.get(infoDisplay.getId());
        if (infoDisplayConfig == null) {
            infoDisplayConfig = InfoDisplayConfigClientUtils.createDefaultConfig(infoDisplay, null, this.clientSide);
        }
        String configStateString = infoDisplayConfig.getState();
        moveable.textColor = infoDisplayConfig.getTextColor();
        moveable.backgroundColor = infoDisplayConfig.getBackgroundColor();
        moveable.state = configStateString == null ? null : infoDisplay.getCodec().decode(configStateString, null, null);
        return moveable;
    }

    private <T> void refreshEntry(MoveableEntry<T> moveable) {
        moveable.clearSubElements();
        this.addSubElements(moveable);
    }

    public void onExit(class_437 screen) {
        super.onExit(screen);
        if (this.madeChanges) {
            this.onChange.run();
        }
    }

    private void saveToConfigProfile() {
        InfoDisplayManagerConfigData.Builder builder = InfoDisplayManagerConfigData.Builder.begin();
        for (String id : this.currentOrder) {
            MoveableEntry<?> editorEntry = this.moveableEntries.get(id);
            String stateString = this.encodeState(editorEntry);
            builder.add(id, new InfoDisplayConfigData(editorEntry.backgroundColor, editorEntry.textColor, stateString));
        }
        InfoDisplayManagerConfigData outputConfig = builder.build();
        this.config.set(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG, (Object)outputConfig);
        this.madeChanges = true;
    }

    private <T> String encodeState(MoveableEntry<T> editorEntry) {
        return editorEntry.state == null ? null : editorEntry.infoDisplay.getCodec().encode(editorEntry.state, null, null);
    }

    public String[] createColorOptions(String symbol, boolean noneOption, boolean nullOption) {
        int firstColorIndex = (noneOption ? 1 : 0) + (nullOption ? 1 : 0);
        String[] options = new String[MinimapConfigConstants.COLOR_NAMES.length + firstColorIndex];
        if (nullOption) {
            options[0] = "~";
        }
        if (noneOption) {
            options[firstColorIndex - 1] = "\u25a1\u25a1";
        }
        for (int i = 0; i < MinimapConfigConstants.COLOR_NAMES.length; ++i) {
            options[i + firstColorIndex] = "\u00a7" + MinimapConfigConstants.COLOR_CODES[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry<T> moveable) {
        int currentSelectedBackground;
        int currentSelectedTextColor;
        boolean includeNull;
        boolean bl = includeNull = !this.clientSide || this.viewingEnforced;
        if (!(includeNull || moveable.state != null && moveable.textColor != null && moveable.backgroundColor != null)) {
            throw new IllegalArgumentException();
        }
        class_339 stateWidget = moveable.infoDisplay.createWidget(this.field_22789 / 2 + 150 - 102, 0, 100, 20, moveable, this::saveToConfigProfile, includeNull);
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        int n = currentSelectedTextColor = moveable.textColor == null ? -1 : moveable.textColor % MinimapConfigConstants.COLOR_NAMES.length;
        if (includeNull) {
            ++currentSelectedTextColor;
        }
        if (currentSelectedTextColor < 0) {
            currentSelectedTextColor = 0;
            moveable.textColor = includeNull ? null : Integer.valueOf(0);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false, includeNull)).setX(this.field_22789 / 2 - 147).setW(20).setSelected(Integer.valueOf(currentSelectedTextColor)).setContainer((IDropDownContainer)this).setCallback((menu, index) -> {
            moveable.textColor = includeNull && index == 0 ? null : Integer.valueOf(index - (includeNull ? 1 : 0));
            this.saveToConfigProfile();
            return true;
        }).setNarrationTitle((class_2561)class_2561.method_43471((String)"gui.xaero_dropdown_info_display_text_color")).build();
        moveable.addSubElement((class_339)textColorWidget);
        int n2 = moveable.backgroundColor == null ? 0 : (currentSelectedBackground = (moveable.backgroundColor < 0 ? moveable.backgroundColor : moveable.backgroundColor % MinimapConfigConstants.COLOR_NAMES.length) + 1 + (includeNull ? 1 : 0));
        if (currentSelectedBackground < 0) {
            currentSelectedBackground = 0;
            moveable.backgroundColor = includeNull ? null : Integer.valueOf(-1);
        }
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true, includeNull)).setX(this.field_22789 / 2 - 124).setW(20).setSelected(Integer.valueOf(currentSelectedBackground)).setContainer((IDropDownContainer)this).setCallback((menu, index) -> {
            moveable.backgroundColor = includeNull && index == 0 ? null : Integer.valueOf(index - 1 - (includeNull ? 1 : 0));
            this.saveToConfigProfile();
            return true;
        }).setNarrationTitle((class_2561)class_2561.method_43471((String)"gui.xaero_dropdown_info_display_background_color")).build();
        moveable.addSubElement((class_339)backgroundColorWidget);
        if (this.viewingEnforced) {
            if (stateWidget != null) {
                stateWidget.field_22763 = false;
            }
            textColorWidget.field_22763 = false;
            backgroundColorWidget.field_22763 = false;
        }
    }

    public boolean method_25406(double d, double e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
        }
        return super.method_25406(d, e, i);
    }

    public void method_25395(class_364 guiEventListener) {
        super.method_25395(guiEventListener);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.selectionList.method_25394(poseStack, mouseX, mouseY, partialTicks);
        GuiInfoDisplayEdit.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)5, (int)-1);
        if (this.clientSide) {
            GuiInfoDisplayEdit.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)HELP_COMPONENT, (int)(this.field_22789 / 2), (int)(this.field_22790 - 52), (int)-1);
        }
        if (this.viewingEnforced) {
            GuiInfoDisplayEdit.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)SERVER_ENFORCED_COMPONENT, (int)(this.field_22789 / 2), (int)15, (int)-1);
        }
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends class_4280<Entry> {
        private static final class_2561 USAGE_NARRATION = class_2561.method_43471((String)"narration.selection.usage");
        private static final class_2561 LEFT_RIGHT_USAGE = class_2561.method_43471((String)"narration.xaero_ui_list_left_right_usage");
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.field_22787, GuiInfoDisplayEdit.this.field_22789, GuiInfoDisplayEdit.this.field_22790, 30, GuiInfoDisplayEdit.this.field_22790 - 61, 24);
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected((Entry)this.method_25326(GuiInfoDisplayEdit.this.selected));
            }
            this.dragged = -1;
        }

        public boolean method_25316() {
            return GuiInfoDisplayEdit.this.method_25399() == this;
        }

        public void setSelected(Entry entry) {
            Entry oldSelected;
            if (GuiInfoDisplayEdit.this.subSelected != -1 && (oldSelected = (Entry)this.method_25334()) != null) {
                MoveableEntry<?> moveable = oldSelected.getMoveable();
                moveable.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_25407(true);
            }
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
            GuiInfoDisplayEdit.this.subSelected = -1;
            super.method_25313((class_350.class_351)entry);
            super.method_25395((class_364)entry);
        }

        public void method_37020(class_6382 narrationElementOutput) {
            super.method_37020(narrationElementOutput);
            if (this.method_25316()) {
                narrationElementOutput.method_37035(class_6381.field_33791, new class_2561[]{USAGE_NARRATION, LEFT_RIGHT_USAGE});
            }
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.currentOrder.size(); ++i) {
                Entry entry = new Entry(i);
                this.method_25321((class_350.class_351)entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 164;
        }

        public int method_25322() {
            return 300;
        }

        public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(poseStack, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = (Entry)this.method_25326(this.dragged);
                draggedEntry.renderNonInteractable(poseStack, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                Entry hoveredEntry = (Entry)this.method_25308(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                    GuiInfoDisplayEdit.this.saveToConfigProfile();
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected(null);
            }
        }

        public class Entry
        extends class_4280.class_4281<Entry> {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;
            private int lastMouseX;
            private int lastMouseY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(class_4587 poseStack, int x, int y) {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                class_332.method_27535((class_4587)poseStack, (class_327)GuiInfoDisplayEdit.this.field_22793, (class_2561)infoDisplay.getName(), (int)(x + 48), (int)(y + 6), (int)-1);
            }

            private MoveableEntry<?> getMoveable() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void method_25343(class_4587 poseStack, int index, int y, int x, int l, int m, int mouseX, int mouseY, boolean bl, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(poseStack, x, y);
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    subElement.field_22761 = y - 2 + 12 - subElement.method_25364() / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.field_22761;
                    }
                    subElement.method_25394(poseStack, mouseX, mouseY, partialTicks);
                }
            }

            public boolean method_25402(double d, double e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    if (!subElement.method_25405(d, e) || !subElement.method_25402(d, e, i)) continue;
                    return true;
                }
                if (i == 0) {
                    if (SelectionList.this.method_25334() != this) {
                        SelectionList.this.setSelected(this);
                    } else {
                        SelectionList.this.setSelected(null);
                    }
                    SelectionList.this.dragging = false;
                    if (!GuiInfoDisplayEdit.this.clientSide || GuiInfoDisplayEdit.this.viewingEnforced) {
                        return true;
                    }
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected(null);
                }
                return super.method_25402(d, e, i);
            }

            public boolean method_25406(double d, double e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    subElement.method_25406(d, e, i);
                }
                return super.method_25406(d, e, i);
            }

            public void method_16014(double d, double e) {
                this.lastMouseX = (int)d;
                this.lastMouseY = (int)e;
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    if (!subElement.method_25405(d, e)) continue;
                    subElement.method_16014(d, e);
                }
                super.method_16014(d, e);
            }

            public boolean method_25403(double d, double e, int i, double f, double g) {
                this.lastMouseX = (int)d;
                this.lastMouseY = (int)e;
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    if (!subElement.method_25405(d, e) || !subElement.method_25403(d, e, i, f, g)) continue;
                    return true;
                }
                return super.method_25403(d, e, i, f, g);
            }

            public boolean method_25401(double d, double e, double f) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (class_339 subElement : moveableEntry.subElements) {
                    if (!subElement.method_25405(d, e) || !subElement.method_25401(d, e, f)) continue;
                    return true;
                }
                return super.method_25401(d, e, f);
            }

            public boolean method_25404(int i, int j, int k) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (i == 262 || i == 263) {
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_25407(true);
                    }
                    if (i == 262) {
                        ++GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected == moveableEntry.subElements.size()) {
                            GuiInfoDisplayEdit.this.subSelected = -1;
                        }
                    } else {
                        --GuiInfoDisplayEdit.this.subSelected;
                        if (GuiInfoDisplayEdit.this.subSelected < -1) {
                            GuiInfoDisplayEdit.this.subSelected = moveableEntry.subElements.size() - 1;
                        }
                    }
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_25407(true);
                    }
                } else if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_25404(i, j, k)) {
                    return true;
                }
                return super.method_25404(i, j, k);
            }

            public boolean method_16803(int i, int j, int k) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_16803(i, j, k)) {
                    return true;
                }
                return super.method_16803(i, j, k);
            }

            public boolean method_25400(char c, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected).method_25400(c, i)) {
                    return true;
                }
                return super.method_25400(c, i);
            }

            public void method_37020(class_6382 narrationElementOutput) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                int sub = -1;
                if (GuiInfoDisplayEdit.this.selected == this.index && GuiInfoDisplayEdit.this.subSelected >= 0) {
                    sub = GuiInfoDisplayEdit.this.subSelected;
                } else {
                    for (int i = 0; i < moveableEntry.subElements.size(); ++i) {
                        if (!moveableEntry.subElements.get(i).method_25405((double)this.lastMouseX, (double)this.lastMouseY)) continue;
                        sub = i;
                    }
                }
                if (sub >= 0) {
                    moveableEntry.subElements.get(sub).method_37020(narrationElementOutput);
                } else {
                    super.method_37020(narrationElementOutput);
                }
            }

            public class_2561 method_37006() {
                String infoDisplayId = GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                String narration = infoDisplay.getName().getString();
                return class_2561.method_43470((String)class_1074.method_4662((String)"narrator.select", (Object[])new Object[]{narration}));
            }
        }
    }

    public class MoveableEntry<T> {
        private final List<class_339> subElements;
        private final InfoDisplay<T> infoDisplay;
        private T state;
        private Integer textColor;
        private Integer backgroundColor;

        public MoveableEntry(InfoDisplay<T> infoDisplay) {
            this.infoDisplay = infoDisplay;
            this.subElements = new ArrayList<class_339>();
        }

        public void addSubElement(class_339 widget) {
            this.subElements.add(widget);
        }

        public T getState() {
            return this.state;
        }

        public void setState(T state) {
            this.state = state;
        }

        private void clearSubElements() {
            this.subElements.clear();
        }
    }
}

