/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiChoosePreset;
import xaero.common.gui.GuiInstructions;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleManager;
import xaero.hud.module.ModuleSession;
import xaero.hud.module.ModuleTransform;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.Tooltip;

public class GuiEditMode
extends ScreenBase {
    public static final ITextComponent CENTERED_COMPONENT = new TextComponentTranslation("gui.xaero_centered", new Object[0]);
    public static final ITextComponent FLIPPED_COMPONENT = new TextComponentTranslation("gui.xaero_flipped", new Object[0]);
    public static final ITextComponent TRUE_COMPONENT = new TextComponentTranslation("gui.yes", new Object[0]);
    public static final ITextComponent FALSE_COMPONENT = new TextComponentTranslation("gui.no", new Object[0]);
    public static final ITextComponent PRESS_C_COMPONENT = new TextComponentTranslation("gui.xaero_press_c", new Object[0]);
    public static final ITextComponent PRESS_F_COMPONENT = new TextComponentTranslation("gui.xaero_press_f", new Object[0]);
    public static final ITextComponent NOT_INGAME = new TextComponentTranslation("gui.xaero_not_ingame", new Object[0]);
    private final int NORMAL_COLOR = 1354612157;
    private final int HOVERED_COLOR = 0x64FFFFFF;
    private final int SELECTED_COLOR = -2097152001;
    private final boolean instructions;
    private final ITextComponent message;
    private HudModule<?> draggedModule;
    private HudModule<?> selectedModule;
    private HudModule<?> lastFrameHoveredModule;
    private int dragOffsetX;
    private int dragOffsetY;
    private final IXaeroMinimap modMain;

    public GuiEditMode(IXaeroMinimap modMain, GuiScreen parent, GuiScreen escape, boolean instructions, ITextComponent message) {
        super(parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_edit_mode", new Object[0]));
        this.modMain = modMain;
        this.instructions = instructions;
        this.message = message;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.draggedModule = null;
        this.selectedModule = null;
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 143, (ITextComponent)new TextComponentTranslation("gui.xaero_confirm", new Object[0])));
        this.field_146292_n.add(new MySmallButton(202, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 143, (ITextComponent)new TextComponentTranslation("gui.xaero_choose_a_preset", new Object[0])));
        if (this.instructions) {
            this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_cancel", new Object[0])));
            this.field_146292_n.add(new MySmallButton(203, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_instructions", new Object[0])));
            return;
        }
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_cancel", new Object[0])));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 200: {
                this.confirm();
                break;
            }
            case 201: {
                this.cancel();
                break;
            }
            case 202: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiChoosePreset(this.modMain, (GuiScreen)this, this.escape));
                break;
            }
            case 203: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiInstructions(this.modMain, (GuiScreen)this, this.escape));
            }
        }
    }

    private void confirm() {
        for (HudPreset hudPreset : this.modMain.getHud().getPresetManager().getPresets()) {
            hudPreset.confirm();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> hudModule : manager.getModules()) {
            hudModule.confirmTransform();
        }
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException iOException) {
            HudMod.LOGGER.error("suppressed exception", (Throwable)iOException);
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void cancel() {
        for (HudPreset preset : this.modMain.getHud().getPresetManager().getPresets()) {
            preset.cancel();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            module.cancelTransform();
        }
        this.goBack();
    }

    private void applyPushes() {
        double screenScale = this.guiScaleFactor;
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            Object session = module.getCurrentSession();
            if (!((ModuleSession)session).isActive()) continue;
            PushboxHandler.State pushState = module.getPushState();
            pushState.resetForModule((ModuleSession<?>)session, this.field_146294_l, this.field_146295_m, screenScale);
            this.modMain.getHudRenderer().getPushboxHandler().applyScreenEdges(pushState, this.field_146294_l, this.field_146295_m, screenScale);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146297_k.field_71439_g == null) {
            super.func_146276_q_();
            this.func_73732_a(this.field_146289_q, NOT_INGAME.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 6 + 128, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.message.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 6 + 128, 0xFFFFFF);
        }
        if (XaeroMinimapSession.getCurrentSession() == null) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        double screenScale = this.guiScaleFactor;
        this.handleDraggedModule(mouseX, mouseY, screenScale);
        this.applyPushes();
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        this.lastFrameHoveredModule = this.getHoveredModule(mouseX, mouseY);
        HudModule<?> hoveredModule = this.lastFrameHoveredModule;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive()) continue;
            this.renderModuleBox(module, hoveredModule, screenScale);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (hoveredModule != null && this.draggedModule == null) {
            Tooltip tooltip = new Tooltip(this.getTooltipText(hoveredModule));
            tooltip.setStartWidth(150);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            tooltip.drawBox(mouseX, mouseY, this.field_146294_l, this.field_146295_m);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        }
    }

    private <MS extends ModuleSession<MS>> void renderModuleBox(HudModule<MS> module, HudModule<?> hoveredModule, double screenScale) {
        MS session = module.getCurrentSession();
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        boolean hovered = hoveredModule == module;
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        GuiEditMode.func_73734_a((int)boxX, (int)boxY, (int)(boxX + moduleW), (int)(boxY + moduleH), (int)(this.selectedModule == module ? -2097152001 : (hovered ? 0x64FFFFFF : 1354612157)));
    }

    private HudModule<?> getHoveredModule(int mouseX, int mouseY) {
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        HudModule<?> result = null;
        int resultSize = 0;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive() || !this.isHovered(module, mouseX, mouseY)) continue;
            int moduleW = module.getPushState().w;
            int moduleH = module.getPushState().h;
            if (module != this.selectedModule && result != null && moduleW * moduleH > resultSize) continue;
            result = module;
            resultSize = moduleW * moduleH;
        }
        return result;
    }

    private boolean isHovered(HudModule<?> module, int mouseX, int mouseY) {
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        return mouseX >= boxX && mouseX < boxX + pushState.w && mouseY >= boxY && mouseY < boxY + pushState.h;
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (this.handledMouseInput || XaeroMinimapSession.getCurrentSession() == null) {
            return;
        }
        this.applyPushes();
        this.draggedModule = this.getHoveredModule(mouseX, mouseY);
        this.selectedModule = this.draggedModule;
        if (this.draggedModule != null) {
            this.dragOffsetX = this.draggedModule.getPushState().x - mouseX;
            this.dragOffsetY = this.draggedModule.getPushState().y - mouseY;
            this.handledMouseInput = true;
            return;
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        this.draggedModule = null;
        super.func_146286_b(mouseX, mouseY, button);
    }

    public void func_73869_a(char typedChar, int code) throws IOException {
        HudModule<?> affectedModule;
        HudModule<?> hudModule = affectedModule = this.selectedModule != null ? this.selectedModule : this.lastFrameHoveredModule;
        if (affectedModule != null && (code == 46 || code == 33 || code == 31)) {
            ModuleTransform transform = affectedModule.getUnconfirmedTransform();
            switch (code) {
                case 46: {
                    int oldModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.field_146295_m, this.guiScaleFactor);
                    boolean bl = transform.centered = !transform.centered;
                    if (this.draggedModule == null) break;
                    int newModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.field_146295_m, this.guiScaleFactor);
                    this.dragOffsetY += newModuleY - oldModuleY;
                    break;
                }
                case 33: {
                    boolean curFlippedHor = transform.flippedHor;
                    transform.flippedHor = !transform.flippedVer;
                    transform.flippedVer = curFlippedHor;
                    break;
                }
                case 31: {
                    GuiScreen configScreen = affectedModule.getConfigScreenFactory().apply((GuiScreen)this);
                    if (configScreen == null) break;
                    this.field_146297_k.func_147108_a(configScreen);
                }
            }
        }
        super.func_73869_a(typedChar, code);
    }

    private void handleDraggedModule(int mouseX, int mouseY, double screenScale) {
        if (this.draggedModule == null) {
            return;
        }
        Object session = this.draggedModule.getCurrentSession();
        if (session == null) {
            return;
        }
        ModuleTransform transform = this.draggedModule.getUnconfirmedTransform();
        transform.y = mouseY + this.dragOffsetY;
        transform.fromBottom = false;
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        int yFromBottom = this.field_146295_m - transform.y - moduleH;
        if (transform.y > yFromBottom) {
            transform.fromBottom = true;
            transform.y = yFromBottom;
        }
        if (transform.centered) {
            return;
        }
        transform.x = mouseX + this.dragOffsetX;
        transform.fromRight = false;
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int xFromRight = this.field_146294_l - transform.x - moduleW;
        if (transform.x > xFromRight) {
            transform.fromRight = true;
            transform.x = xFromRight;
        }
    }

    private ITextComponent getTooltipText(HudModule<?> hoveredModule) {
        ModuleTransform transform = hoveredModule.getUnconfirmedTransform();
        TextComponentTranslation centeredLine = new TextComponentTranslation("%s %s %s", new Object[]{CENTERED_COMPONENT, transform.centered ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_C_COMPONENT});
        TextComponentTranslation flippedLine = new TextComponentTranslation("%s %s %s %s", new Object[]{FLIPPED_COMPONENT, transform.flippedHor ? TRUE_COMPONENT : FALSE_COMPONENT, transform.flippedVer ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_F_COMPONENT});
        return new TextComponentTranslation("%s \\n %s \\n %s", new Object[]{hoveredModule.getDisplayName(), centeredLine, flippedLine});
    }
}

