/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import xaero.hud.category.serialization.data.ObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataSerializer;

public class ObjectCategoryDataNbtSerializer<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataSerializer<D, NBTTagCompound> {
    private final Supplier<DB> builderSupplier;

    protected ObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public NBTTagCompound serialize(D data) {
        NBTTagCompound resultTag = new NBTTagCompound();
        resultTag.func_74778_a("n", ((ObjectCategoryData)data).getName());
        resultTag.func_74757_a("p", ((ObjectCategoryData)data).getProtection());
        final NBTTagCompound settingOverrides = new NBTTagCompound();
        ((ObjectCategoryData)data).getSettingOverrideIterator().forEachRemaining(new Consumer<Map.Entry<String, Object>>(){

            @Override
            public void accept(Map.Entry<String, Object> entry) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    return;
                }
                if (value instanceof Boolean) {
                    settingOverrides.func_74757_a(key, ((Boolean)value).booleanValue());
                    return;
                }
                if (value instanceof Double) {
                    settingOverrides.func_74780_a(key, ((Double)value).doubleValue());
                    return;
                }
                if (value instanceof Integer) {
                    settingOverrides.func_74768_a(key, ((Integer)value).intValue());
                    return;
                }
                throw new IllegalArgumentException("Unsupported category setting type: " + value.getClass());
            }
        });
        resultTag.func_74782_a("v", (NBTBase)settingOverrides);
        final NBTTagList subCategoriesTag = new NBTTagList();
        ((ObjectCategoryData)data).getSubCategoryIterator().forEachRemaining(new Consumer<D>(){

            @Override
            public void accept(D sub) {
                NBTTagCompound subCategoryTag = ObjectCategoryDataNbtSerializer.this.serialize(sub);
                subCategoriesTag.func_74742_a((NBTBase)subCategoryTag);
            }
        });
        resultTag.func_74782_a("s", (NBTBase)subCategoriesTag);
        return resultTag;
    }

    @Override
    public final D deserialize(NBTTagCompound serializedData) {
        return ((ObjectCategoryData.Builder)this.getConfiguredBuilder(serializedData)).build();
    }

    protected DB getConfiguredBuilder(NBTTagCompound serializedData) {
        ObjectCategoryData.Builder builder = (ObjectCategoryData.Builder)this.builderSupplier.get();
        builder.setName(serializedData.func_74779_i("n"));
        builder.setProtection(serializedData.func_74767_n("p"));
        NBTTagCompound settingOverrides = serializedData.func_74775_l("v");
        for (String key : settingOverrides.func_150296_c()) {
            NBTBase valueTag = settingOverrides.func_74781_a(key);
            if (valueTag instanceof NBTTagByte) {
                builder.setSettingOverride(key, ((NBTTagByte)valueTag).func_150290_f() == 1);
                continue;
            }
            if (valueTag instanceof NBTTagDouble) {
                builder.setSettingOverride(key, ((NBTTagDouble)valueTag).func_150286_g());
                continue;
            }
            if (valueTag instanceof NBTTagInt) {
                builder.setSettingOverride(key, ((NBTTagInt)valueTag).func_150287_d());
                continue;
            }
            throw new IllegalArgumentException("Unsupported category setting NBT tag type: " + valueTag.getClass());
        }
        NBTTagList subCategoriesTag = serializedData.func_150295_c("s", 10);
        for (NBTBase subCategoryTag : subCategoriesTag) {
            builder.addSubCategoryBuilder(this.getConfiguredBuilder((NBTTagCompound)subCategoryTag));
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected ObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new ObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends ObjectCategoryData<D>, DB extends ObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>> {
        protected final B self = this;
        protected Supplier<DB> builderSupplier;

        protected Builder() {
        }

        public B setDefault() {
            this.setBuilderSupplier(null);
            return this.self;
        }

        public B setBuilderSupplier(Supplier<DB> builderSupplier) {
            this.builderSupplier = builderSupplier;
            return this.self;
        }

        public ObjectCategoryDataNbtSerializer<D, DB> build() {
            if (this.builderSupplier == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ObjectCategoryDataNbtSerializer<D, DB> buildInternally();
    }
}

