/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.packet.basic;

import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.lib.common.packet.XaeroPacket;

public class ClientboundRulesPacket
extends XaeroPacket {
    public boolean allowCaveModeOnServer;
    public boolean allowNetherCaveModeOnServer;
    public boolean allowRadarOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer, boolean allowRadarOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
        this.allowRadarOnServer = allowRadarOnServer;
    }

    public ClientboundRulesPacket() {
    }

    protected void read(PacketBuffer buf) {
        NBTTagCompound nbt = this.readDefaultTag(buf);
        if (nbt == null) {
            return;
        }
        this.allowCaveModeOnServer = nbt.func_74767_n("cm");
        this.allowNetherCaveModeOnServer = nbt.func_74767_n("ncm");
        this.allowRadarOnServer = nbt.func_74767_n("r");
    }

    protected void write(PacketBuffer buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("cm", this.allowCaveModeOnServer);
        nbt.func_74757_a("ncm", this.allowNetherCaveModeOnServer);
        nbt.func_74757_a("r", this.allowRadarOnServer);
        buf.func_150786_a(nbt);
    }

    public static class ClientHandler
    implements Consumer<ClientboundRulesPacket> {
        @Override
        public void accept(ClientboundRulesPacket message) {
            MinimapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

