/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry.widget;

import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import xaero.common.gui.MySlider;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.widget.ICategorySettingsWidget;

public class EditorSlider
extends MySlider
implements ICategorySettingsWidget {
    protected int currentIndex;
    protected int optionCount;
    protected IntConsumer updatedIndexConsumer;
    protected Supplier<ITextComponent> messageSupplier;
    protected final GuiCategoryEditor.SettingRowList rowList;

    public EditorSlider(IntConsumer updatedIndexConsumer, Supplier<ITextComponent> messageSupplier, int currentIndex, int optionCount, int widthIn, int heightIn, GuiCategoryEditor.SettingRowList rowList, int scaledScreenWidth) {
        super(0, 2, 2, widthIn, heightIn, 0.0f, 1.0f, scaledScreenWidth);
        this.updatedIndexConsumer = updatedIndexConsumer;
        this.messageSupplier = messageSupplier;
        this.optionCount = optionCount;
        this.currentIndex = currentIndex;
        this.sliderValue = this.toSliderValue(currentIndex);
        this.rowList = rowList;
        this.updateMessage();
    }

    @Override
    protected void applyValue() {
        this.currentIndex = this.toValue(this.sliderValue);
        this.updatedIndexConsumer.accept(this.currentIndex);
    }

    @Override
    protected void updateMessage() {
        this.xaero_setMessage(this.messageSupplier.get().func_150254_d());
    }

    public double toSliderValue(int i) {
        return (double)i / (double)(this.optionCount - 1);
    }

    public int toValue(double d) {
        return (int)this.clamp(MathHelper.func_151238_b((double)0.0, (double)(this.optionCount - 1), (double)d));
    }

    private double clamp(double d) {
        d = Math.round(d);
        return d;
    }

    @Override
    public void xaero_mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
    }

    @Override
    public void xaero_tick() {
    }

    @Override
    public String xaero_getMessage() {
        return this.field_146126_j;
    }

    @Override
    public boolean xaero_isEnabled() {
        return this.field_146124_l;
    }

    @Override
    public void xaero_setEnabled(boolean b) {
        this.field_146124_l = b;
    }

    @Override
    public void xaero_setMessage(String message) {
        this.field_146126_j = message;
    }

    @Override
    public void xaero_keyTyped(char c, int i) {
    }

    @Override
    public void xaero_setFocused(boolean bl) {
    }

    @Override
    public void xaero_drawButton(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean xaero_mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return super.func_146116_c(mc, mouseX, mouseY);
    }

    @Override
    public void xaero_mouseReleased(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
    }
}

