/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node.options.text;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.misc.ListFactory;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryExpandingOptions;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.entry.widget.EditorTextField;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorExpandingOptionsNode;
import xaero.hud.category.ui.node.options.EditorOptionNode;
import xaero.hud.category.ui.node.options.EditorOptionsNode;
import xaero.hud.category.ui.node.options.text.TextFieldSuggestionsResolver;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;

public final class EditorTextFieldOptionsNode
extends EditorExpandingOptionsNode<String> {
    private String input;
    private String result;
    private int cursorPos;
    private int highlightPos;
    private final int maxLength;
    private EditorTextField.UpdatedValueConsumer updatedValueConsumer;
    private List<EditorOptionNode<String>> suggestions;
    private final TextFieldSuggestionsResolver suggestionsResolver;
    private final boolean allowCustomInput;
    private final boolean autoConfirm;
    private final Predicate<String> inputStringValidator;

    protected EditorTextFieldOptionsNode(@Nonnull ITextComponent displayName, @Nonnull String input, int maxLength, @Nonnull EditorOptionNode<String> currentValue, @Nonnull List<EditorOptionNode<String>> options, @Nonnull TextFieldSuggestionsResolver suggestionsResolver, boolean movable, @Nonnull EditorListRootEntryFactory listEntryFactory, boolean allowCustomInput, boolean autoConfirm, IEditorDataTooltipSupplier tooltipSupplier, EditorOptionsNode.IOptionsNodeIsActiveSupplier isActiveSupplier, Predicate<String> inputStringValidator) {
        super(displayName, currentValue, options, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.maxLength = maxLength;
        this.resetInput(input);
        this.suggestionsResolver = suggestionsResolver;
        this.allowCustomInput = allowCustomInput;
        this.autoConfirm = autoConfirm;
        this.inputStringValidator = inputStringValidator;
    }

    public void resetInput(String input) {
        this.input = input;
        this.result = input;
        this.cursorPos = this.highlightPos = input.length();
    }

    @Override
    public void setCurrentValue(EditorOptionNode<String> currentValue) {
    }

    @Override
    public EditorOptionNode<String> getCurrentValue() {
        return EditorOptionNode.Builder.begin().setValue(this.input).build();
    }

    public String getInput() {
        return this.input;
    }

    public String getResult() {
        return this.result;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public int getHighlightPos() {
        return this.highlightPos;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (!expanded) {
            this.resetInput(this.result);
            this.suggestions = null;
        }
        super.setExpanded(expanded);
    }

    @Override
    public boolean onSelected(EditorOptionNode<String> option) {
        boolean result = super.onSelected(option);
        this.resetInput(option.getValue().toString());
        return result;
    }

    public EditorTextField.UpdatedValueConsumer getUpdatedValueConsumer() {
        if (this.updatedValueConsumer == null) {
            this.updatedValueConsumer = new EditorTextField.UpdatedValueConsumer(){

                @Override
                public void accept(String s, int c, int h, GuiCategoryEditor.SettingRowList rl) {
                    EditorTextFieldOptionsNode.this.cursorPos = c;
                    EditorTextFieldOptionsNode.this.highlightPos = h;
                    String oldInput = EditorTextFieldOptionsNode.this.input;
                    if (oldInput != null && oldInput.equals(s)) {
                        return;
                    }
                    EditorTextFieldOptionsNode.this.input = s;
                    EditorTextFieldOptionsNode.this.suggestions = EditorTextFieldOptionsNode.this.suggestionsResolver.getSuggestions(s, EditorTextFieldOptionsNode.this.options);
                    if (EditorTextFieldOptionsNode.this.autoConfirm) {
                        EditorTextFieldOptionsNode.this.result = s;
                    }
                    if (!EditorTextFieldOptionsNode.this.autoConfirm && EditorTextFieldOptionsNode.this.allowCustomInput && !s.isEmpty() && EditorTextFieldOptionsNode.this.inputStringValidator.test(s)) {
                        EditorTextFieldOptionsNode.this.suggestions.add(0, EditorOptionNode.Builder.begin().setValue(s).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_category_add_to_list_custom", new Object[]{s})).build());
                    }
                    if (!EditorTextFieldOptionsNode.this.suggestions.isEmpty()) {
                        EditorTextFieldOptionsNode.this.setExpanded(true);
                    } else if (s.isEmpty()) {
                        EditorTextFieldOptionsNode.this.setExpanded(false);
                    }
                    if (EditorTextFieldOptionsNode.this.autoConfirm) {
                        rl.restoreScrollAfterUpdate();
                    }
                    rl.setLastExpandedData(EditorTextFieldOptionsNode.this);
                    rl.updateEntries();
                }
            };
        }
        return this.updatedValueConsumer;
    }

    @Override
    public List<EditorNode> getSubNodes() {
        return this.suggestions;
    }

    public static final class Builder
    extends EditorExpandingOptionsNode.Builder<String, Builder> {
        private String input;
        private int maxLength;
        private final EditorOptionNode.Builder<String> currentInputOption = EditorOptionNode.Builder.begin();
        private final TextFieldSuggestionsResolver.Builder suggestionsResolverBuilder;
        private boolean allowCustomInput;
        private boolean autoConfirm;
        private Predicate<String> inputStringValidator;

        private Builder(ListFactory listFactory) {
            super(listFactory);
            this.suggestionsResolverBuilder = TextFieldSuggestionsResolver.Builder.begin(listFactory);
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setInput("");
            this.setMaxLength(100);
            ((EditorOptionNode.Builder)this.currentInputOption.setDefault()).setDisplayName((ITextComponent)new TextComponentString("null holder"));
            this.addOptionBuilder(this.currentInputOption);
            this.setAllowCustomInput(true);
            this.setAutoConfirm(true);
            this.setInputStringValidator(null);
            this.suggestionsResolverBuilder.setDefault();
            return this;
        }

        @Override
        protected EditorListRootEntry.CenteredEntryFactory getCenteredEntryFactory(final EditorNode data, final EditorNode parent, final int index, final GuiCategoryEditor.SettingRowList rowList) {
            return new EditorListRootEntry.CenteredEntryFactory(){

                @Override
                public EditorListEntry get(int x, int y, int width, int height, EditorListRootEntry root) {
                    EditorTextFieldOptionsNode tfoData = (EditorTextFieldOptionsNode)data;
                    EditorTextField widget = new EditorTextField(tfoData.getUpdatedValueConsumer(), tfoData.getInput(), tfoData.getCursorPos(), tfoData.getHighlightPos(), tfoData.getMaxLength(), Minecraft.func_71410_x().field_71466_p, 214, 18, data.getDisplayName(), tfoData.inputStringValidator, rowList);
                    if (rowList.readOnly) {
                        widget.func_146184_c(false);
                    }
                    return new EditorListEntryExpandingOptions(x, y, width, height, index, rowList, root, widget, null, data.getTooltipSupplier(parent));
                }
            };
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public Builder setInputStringValidator(Predicate<String> inputStringValidator) {
            this.inputStringValidator = inputStringValidator;
            return this;
        }

        public boolean needsInputStringValidator() {
            return this.inputStringValidator == null;
        }

        public Builder setAllowCustomInput(boolean allowCustomInput) {
            this.allowCustomInput = allowCustomInput;
            return this;
        }

        public Builder setAutoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            return this;
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @Override
        public Builder setCurrentValue(String currentValue) {
            return this;
        }

        @Override
        public EditorTextFieldOptionsNode build() {
            if (this.input == null || this.inputStringValidator == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (EditorTextFieldOptionsNode)super.build();
        }

        protected EditorTextFieldOptionsNode buildInternally(EditorOptionNode<String> currentValueData, List<EditorOptionNode<String>> options) {
            return new EditorTextFieldOptionsNode(this.displayName, this.input, this.maxLength, currentValueData, options, this.suggestionsResolverBuilder.build(), this.movable, this.listEntryFactory, this.allowCustomInput, this.autoConfirm, this.tooltipSupplier, this.isActiveSupplier, this.inputStringValidator);
        }

        public static Builder begin(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }
    }
}

