/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;

public class Misc {
    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.field_71417_B.func_198024_e();
        }
        return mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198105_m();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.field_71417_B.func_198026_f();
        }
        return mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198091_l() / (double)mc.func_228018_at_().func_198083_n();
    }

    public static void drawNormalText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawNormalText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_243247_a(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_243247_a(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void minecraftOrtho(Minecraft mc, boolean raw) {
        MainWindow mainwindow = mc.func_228018_at_();
        int width = raw ? mainwindow.func_198105_m() : mainwindow.func_198109_k();
        int height = raw ? mainwindow.func_198083_n() : mainwindow.func_198091_l();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)width / mainwindow.func_198100_s()), (double)((double)height / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)ForgeHooksClient.getGuiFarPlane());
    }

    public static void defaultOrtho(Framebuffer framebuffer, boolean raw) {
        if (framebuffer != null) {
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)framebuffer.field_147622_a, (double)framebuffer.field_147620_b, (double)0.0, (double)1000.0, (double)3000.0);
        } else {
            Misc.minecraftOrtho(Minecraft.func_71410_x(), raw);
        }
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return chunk.func_76632_l().func_201841_a();
    }

    public static boolean hasItem(PlayerEntity player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static ITextComponent getFixedDisplayName(Entity e) {
        ITextComponent baseName = e.func_200200_C_();
        if (baseName == null) {
            return null;
        }
        return e.func_96124_cp() == null ? baseName.func_230532_e_() : e.func_96124_cp().func_230427_d_((ITextComponent)baseName.func_230532_e_());
    }

    public static boolean hasEffect(PlayerEntity player, Effect effect) {
        return effect != null && player != null && player.func_70644_a(effect);
    }

    public static boolean hasEffect(Effect effect) {
        return Misc.hasEffect((PlayerEntity)Minecraft.func_71410_x().field_71439_g, effect);
    }
}

