/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.hud.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.value.io.serialization.BuiltInConfigValueIOCodecs;
import xaero.lib.common.config.option.value.io.serialization.ConfigValueIOCodec;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = InfoDisplay.Builder.begin().setId("coords").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_coords")).setDefaultState(true).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        String coords = playerPos.func_177958_n() + ", " + playerPos.func_177956_o() + ", " + playerPos.func_177952_p();
        if (Minecraft.func_71410_x().field_71466_p.func_78256_a(coords) >= availableWidth) {
            String stringLevel = "" + playerPos.func_177956_o();
            coords = playerPos.func_177958_n() + ", " + playerPos.func_177952_p();
            compiler.addLine(coords);
            compiler.addLine(stringLevel);
        } else {
            compiler.addLine(coords);
        }
    }).setLegacyGetter(legacySettings -> {
        Boolean result = legacySettings.showCoordsLegacy;
        legacySettings.showCoordsLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = InfoDisplay.Builder.begin().setId("overworld_coords").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_overworld_coords")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double coordinateScale = mc.field_71441_e.func_230315_m_().func_242724_f();
        if (coordinateScale == 1.0) {
            return;
        }
        int overworldPlayerX = MathHelper.func_76128_c((double)((double)playerPos.func_177958_n() * coordinateScale));
        int overworldPlayerZ = MathHelper.func_76128_c((double)((double)playerPos.func_177952_p() * coordinateScale));
        String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
        compiler.addWords(coords);
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = InfoDisplay.Builder.begin().setId("chunk_coords").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_chunk_coords")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        int chunkX = playerPos.func_177958_n() >> 4;
        int chunkZ = playerPos.func_177952_p() >> 4;
        int insideX = playerPos.func_177958_n() & 0xF;
        int insideZ = playerPos.func_177952_p() & 0xF;
        String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
        compiler.addWords(coords);
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> ANGLES = InfoDisplay.Builder.begin().setId("angles").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_angles")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        compiler.addLine((ITextComponent)new StringTextComponent(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70125_A)))));
    }).setLegacyGetter(legacySettings -> {
        Boolean result = legacySettings.showAnglesLegacy;
        legacySettings.showAnglesLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> DIMENSION = InfoDisplay.Builder.begin().setId("dimension").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_dimension")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        ResourceLocation dimensionId = Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_();
        if (dimensionId != null) {
            String dimensionName = dimensionId.func_110624_b().equals("minecraft") ? dimensionId.func_110623_a() : dimensionId.toString();
            compiler.addLine(dimensionName);
        }
    }).setLegacyGetter(legacySettings -> {
        Boolean result = legacySettings.showDimensionNameLegacy;
        legacySettings.showDimensionNameLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> BIOME = InfoDisplay.Builder.begin().setId("biome").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_biome")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        Biome biome = Minecraft.func_71410_x().field_71441_e.func_226691_t_(playerPos);
        ResourceLocation biomeRL = biome == null ? null : Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        String biomeText = biomeRL == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : I18n.func_135052_a((String)("biome." + biomeRL.func_110624_b() + "." + biomeRL.func_110623_a()), (Object[])new Object[0]);
        compiler.addWords(biomeText);
    }).setLegacyGetter(legacySettings -> {
        Boolean result = legacySettings.showBiomeLegacy;
        legacySettings.showBiomeLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> WEATHER = InfoDisplay.Builder.begin().setId("weather").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_weather")).setDefaultState(false).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.func_72911_I()) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_weather_thundering"));
        } else if (Minecraft.func_71410_x().field_71441_e.func_72896_J()) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_weather_raining"));
        }
    }).setLegacyGetter(legacySettings -> {
        Boolean result = legacySettings.displayWeatherInfoLegacy;
        legacySettings.displayWeatherInfoLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Integer> LIGHT_LEVEL = InfoDisplay.Builder.begin().setId("light_level").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_light_level")).setDefaultState(0).setCodec((ConfigValueIOCodec<Integer>)BuiltInConfigValueIOCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("gui.xaero_light_block"), new TranslationTextComponent("gui.xaero_light_sky"), new TranslationTextComponent("gui.xaero_light_all"), new TranslationTextComponent("gui.xaero_light_both2")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showLightLevel = (Integer)displayInfo.getEffectiveState();
        if (showLightLevel == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int blockLight = mc.field_71441_e.func_226658_a_(LightType.BLOCK, playerPos);
        int skyLight = mc.field_71441_e.func_226658_a_(LightType.SKY, playerPos);
        if (showLightLevel == 1) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_block_light_value", new Object[]{blockLight}));
        } else if (showLightLevel == 2) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_sky_light_value", new Object[]{skyLight}));
        } else if (showLightLevel == 3) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
        } else {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
        }
    }).setLegacyGetter(legacySettings -> {
        Integer result = legacySettings.showLightLevelLegacy;
        legacySettings.showLightLevelLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Integer> TIME = InfoDisplay.Builder.begin().setId("time").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_time")).setDefaultState(0).setCodec((ConfigValueIOCodec<Integer>)BuiltInConfigValueIOCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("%s+%s", new Object[]{new TranslationTextComponent("gui.xaero_day"), new TranslationTextComponent("gui.xaero_24h")}), new TranslationTextComponent("%s+%s", new Object[]{new TranslationTextComponent("gui.xaero_day"), new TranslationTextComponent("gui.xaero_12h")}), new TranslationTextComponent("gui.xaero_24h"), new TranslationTextComponent("gui.xaero_12h")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showTime = (Integer)displayInfo.getEffectiveState();
        if (showTime <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long totalTime = 6000L + mc.field_71441_e.func_72820_D();
        int dayNumber = (int)(totalTime / 24000L) + 1;
        int dayTimeSinceMidnight = (int)(totalTime % 24000L);
        int timeHours = dayTimeSinceMidnight / 1000;
        int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
        if ((showTime - 1) % 2 == 0) {
            if (showTime < 3) {
                compiler.addWords(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
            } else {
                compiler.addWords(String.format("%02d:%02d", timeHours, minutes));
            }
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            if (showTime < 3) {
                compiler.addWords(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
            } else {
                compiler.addWords(String.format("%02d:%02d %s", timeHours, minutes, half));
            }
        }
    }).setLegacyGetter(legacySettings -> {
        Integer result = legacySettings.showTimeLegacy;
        legacySettings.showTimeLegacy = null;
        return result;
    }).setDestination(ALL::add).build();
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = InfoDisplay.Builder.begin().setId("real_time").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_real_time")).setDefaultState(0).setCodec((ConfigValueIOCodec<Integer>)BuiltInConfigValueIOCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("gui.xaero_24h"), new TranslationTextComponent("gui.xaero_12h")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showTime = (Integer)displayInfo.getEffectiveState();
        if (showTime <= 0) {
            return;
        }
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        int timeHours = CALENDAR.get(11);
        int minutes = CALENDAR.get(12);
        if (showTime == 1) {
            compiler.addWords(String.format("%02d:%02d IRL", timeHours, minutes));
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            compiler.addWords(String.format("%02d:%02d %s IRL", timeHours, minutes, half));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> HIGHLIGHTS = InfoDisplay.Builder.begin().setId("highlights").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_highlights")).setDefaultState(true).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        if (session.getProcessor().getMinimapWriter().getDimensionHighlightHandler() != null) {
            session.getProcessor().getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerPos.func_177958_n(), playerPos.func_177952_p(), availableWidth, true);
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = InfoDisplay.Builder.begin().setId("light_overlay_indicator").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_light_overlay_indicator")).setDefaultState(true).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        if ((Integer)session.getModMain().getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.LIGHT_OVERLAY_TYPE) > 0) {
            compiler.addWords(I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = InfoDisplay.Builder.begin().setId("manual_cave_mode_indicator").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_manual_cave_mode_indicator")).setDefaultState(true).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        if (session.getProcessor().isManualCaveMode()) {
            compiler.addWords(I18n.func_135052_a((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = InfoDisplay.Builder.begin().setId("custom_sub_world").setName((ITextComponent)new TranslationTextComponent("gui.xaero_infodisplay_custom_sub_world")).setDefaultState(true).setCodec((ConfigValueIOCodec<Boolean>)BuiltInConfigValueIOCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, hudSession, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getEffectiveState()).booleanValue()) {
            return;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager minimapWorldManager = session.getWorldManager();
        MinimapWorld currentWorld = minimapWorldManager.getCurrentWorld();
        if (currentWorld != null && minimapWorldManager.getAutoWorld() != currentWorld) {
            compiler.addWords(I18n.func_135052_a((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{currentWorld.getContainer().getSubName()}));
        }
    }).setDestination(ALL::add).build();

    public static void forEach(Consumer<InfoDisplay<?>> action) {
        ALL.forEach(action);
    }
}

