/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.lib.common.util.IOUtils;

public class MinimapDimensionHelper {
    public double getDimensionDivision(MinimapWorld minimapWorld) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return 1.0;
        }
        double dimCoordinateScale = this.getDimCoordinateScale(minimapWorld);
        return Minecraft.func_71410_x().field_71441_e.func_230315_m_().func_242724_f() / dimCoordinateScale;
    }

    public double getDimCoordinateScale(MinimapWorld minimapWorld) {
        if (minimapWorld == null) {
            return 1.0;
        }
        MinimapWorldRootContainer rootContainer = minimapWorld.getContainer().getRoot();
        RegistryKey<World> dimKey = minimapWorld.getDimId();
        if (dimKey == null) {
            return 1.0;
        }
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(RegistryKey<World> dimKey) {
        if (dimKey == World.field_234918_g_) {
            return "dim%0";
        }
        if (dimKey == World.field_234919_h_) {
            return "dim%-1";
        }
        if (dimKey == World.field_234920_i_) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.func_240901_a_();
        String path = identifier.func_110623_a().replace('/', '%');
        path = IOUtils.replaceTrailingDots((String)path, (char)',');
        return "dim%" + identifier.func_110624_b() + "$" + path;
    }

    public RegistryKey<World> findDimensionKeyForOldName(ClientPlayerEntity player, String oldName) {
        Set allDimensions = player.field_71174_a.func_239164_m_();
        for (RegistryKey dk : allDimensions) {
            if (!oldName.equals(dk.func_240901_a_().func_110623_a().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public RegistryKey<World> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return World.field_234918_g_;
        }
        if (dimIdPart.equals("1")) {
            return World.field_234920_i_;
        }
        if (dimIdPart.equals("-1")) {
            return World.field_234919_h_;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length < 2) {
            return null;
        }
        String path = idArgs[1].replace('%', '/');
        path = path.replace(',', '.');
        try {
            return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(idArgs[0], path));
        }
        catch (ResourceLocationException rle) {
            return null;
        }
    }
}

