/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import xaero.common.graphics.OpenGlHelper;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.lib.client.graphics.util.IPlatformRenderDeviceHelper;
import xaero.lib.platform.Services;

public class MultiTextureRenderTypeRendererProvider {
    private Deque<MultiTextureRenderTypeRenderer> availableRenderers = new ArrayDeque<MultiTextureRenderTypeRenderer>();
    private HashSet<MultiTextureRenderTypeRenderer> usedRenderers;

    public MultiTextureRenderTypeRendererProvider(int rendererCount) {
        for (int i = 0; i < rendererCount; ++i) {
            this.availableRenderers.add(new MultiTextureRenderTypeRenderer());
        }
        this.usedRenderers = new HashSet();
    }

    public MultiTextureRenderTypeRenderer getRenderer(Consumer<GpuTexture> textureBinder, RenderType renderType) {
        return this.getRenderer(textureBinder, null, renderType);
    }

    public MultiTextureRenderTypeRenderer getRenderer(Consumer<GpuTexture> textureBinder, Consumer<GpuTexture> textureFinalizer, RenderType renderType) {
        if (this.availableRenderers.isEmpty()) {
            throw new RuntimeException("No renderers available!");
        }
        MultiTextureRenderTypeRenderer renderer = this.availableRenderers.removeFirst();
        renderer.init(textureBinder, textureFinalizer, renderType);
        this.usedRenderers.add(renderer);
        return renderer;
    }

    public void draw(MultiTextureRenderTypeRenderer renderer) {
        if (!this.usedRenderers.remove(renderer)) {
            throw new RuntimeException("The renderer requested for drawing was not provided by this provider!");
        }
        renderer.draw();
        this.availableRenderers.add(renderer);
    }

    public static void defaultTextureBind(GpuTexture texture) {
        IPlatformRenderDeviceHelper renderDeviceUtil = Services.PLATFORM.getRenderDeviceHelper();
        if (!(renderDeviceUtil.getRealDevice() instanceof GlDevice)) {
            throw new IllegalStateException("Unsupported non-OpenGL rendering detected!");
        }
        GpuTexture realTexture = renderDeviceUtil.getRealTexture(texture);
        OpenGlHelper.bindTexture(0, realTexture);
        if (realTexture != null) {
            ((GlTexture)realTexture).flushModeChanges(3553);
        }
    }
}

