/*
 * Decompiled with CFR 0.152.
 */
package xaero.common;

import java.io.IOException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContext;
import xaero.common.PlatformContextLoaderClientOnlyForge;
import xaero.common.PlatformContextLoaderCommonForge;
import xaero.common.cache.BlockStateShortShapeCache;
import xaero.common.events.ClientEvents;
import xaero.common.events.ClientEventsForge;
import xaero.common.events.CommonEvents;
import xaero.common.events.CommonEventsForge;
import xaero.common.events.ModClientEvents;
import xaero.common.events.ModClientEventsForge;
import xaero.common.events.ModCommonEvents;
import xaero.common.events.ModCommonEventsForge;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.minimap.write.MinimapWriterForge;
import xaero.common.mods.SupportMods;
import xaero.common.mods.SupportModsForge;
import xaero.hud.minimap.module.MinimapSession;

public class PlatformContextForge
extends PlatformContext {
    private PlatformContextLoaderClientOnlyForge loaderClientOnly;
    private PlatformContextLoaderCommonForge loaderCommon;
    private final HudMod modMain;

    public PlatformContextForge(HudMod modMain) {
        this.modMain = modMain;
    }

    public void registerEvents(FMLJavaModLoadingContext context) {
        context.getModEventBus().addListener(this::loadCommonForge);
        context.getModEventBus().addListener(this::loadServerForge);
        context.getModEventBus().addListener(this::loadClientForge);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getCommonEvents());
        context.getModEventBus().register((Object)this.modMain.getModCommonEvents());
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents(context);
        }
    }

    private void registerClientEvents(FMLJavaModLoadingContext context) {
        context.getModEventBus().register((Object)this.modMain.getModClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)this.modMain.getEvents());
    }

    private void loadClientForge(FMLClientSetupEvent event) {
        try {
            this.modMain.loadClient();
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.modMain.getModId()).get();
            ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this.modMain::loadLater);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCommonForge(FMLCommonSetupEvent event) {
        this.modMain.loadCommon();
    }

    private void loadServerForge(FMLDedicatedServerSetupEvent event) {
        this.modMain.loadServer();
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.modMain.getModId()).get();
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this.modMain::loadLaterServer);
    }

    @Override
    public ClientEvents createClientEvents(HudMod modMain) {
        return new ClientEventsForge(modMain);
    }

    @Override
    public CommonEvents createCommonEvents(HudMod modMain) {
        return new CommonEventsForge(modMain);
    }

    @Override
    public PlatformContextLoaderClientOnlyForge getLoaderClientOnly() {
        if (this.loaderClientOnly == null) {
            this.loaderClientOnly = new PlatformContextLoaderClientOnlyForge();
        }
        return this.loaderClientOnly;
    }

    @Override
    public PlatformContextLoaderCommonForge getLoaderCommon() {
        if (this.loaderCommon == null) {
            this.loaderCommon = new PlatformContextLoaderCommonForge();
        }
        return this.loaderCommon;
    }

    @Override
    public ModClientEvents createModClientEvents(IXaeroMinimap modMain) {
        return new ModClientEventsForge(modMain);
    }

    @Override
    public SupportMods createSupportMods(IXaeroMinimap modMain) {
        return new SupportModsForge(modMain);
    }

    @Override
    public ModCommonEvents createModCommonEvents(IXaeroMinimap modMain) {
        return new ModCommonEventsForge(modMain);
    }

    @Override
    public MinimapWriter createMinimapWriter(IXaeroMinimap modMain, MinimapSession xaeroMinimapSession, BlockStateShortShapeCache blockStateShortShapeCache, HighlighterRegistry highlighterRegistry) {
        return new MinimapWriterForge(modMain, xaeroMinimapSession, blockStateShortShapeCache, highlighterRegistry);
    }

    @Override
    public String getModInfoVersion() {
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.modMain.getModId()).get();
        return modContainer.getModInfo().getVersion().toString();
    }
}

