/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import xaero.lib.client.graphics.DynamicImmediateGpuBuffer;
import xaero.lib.client.graphics.GpuBufferSlice;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private ByteBufferBuilder sharedBuffer = new ByteBufferBuilder(16384);
    private BufferBuilder currentBufferBuilder;
    private List<MeshData> buffersForDrawCalls = new ArrayList<MeshData>();
    private List<RenderPass.Draw> drawCallBuilder;
    private DynamicImmediateGpuBuffer immediateVertexBuffer;
    private ArrayList<GpuTexture> texturesForDrawCalls = new ArrayList();
    private Consumer<GpuTexture> textureBinder;
    private Consumer<GpuTexture> textureFinalizer;
    private GpuTexture prevTexture;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
        this.drawCallBuilder = new ArrayList<RenderPass.Draw>();
    }

    void init(Consumer<GpuTexture> textureBinder, Consumer<GpuTexture> textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTexture = null;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            GpuTexture texture;
            Consumer<GpuTexture> textureBinder = this.textureBinder;
            Consumer<GpuTexture> textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.endBuffer(this.currentBufferBuilder);
            RenderPipeline renderPipeline = this.renderType.getRenderPipeline();
            RenderTarget target = this.renderType.getRenderTarget();
            for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                texture = this.texturesForDrawCalls.get(i);
                MeshData meshData = this.buffersForDrawCalls.get(i);
                this.drawCallBuilder.add(this.createDrawCall(meshData, texture, renderPipeline));
                meshData.close();
            }
            this.renderType.setupRenderState();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(target.getColorTexture(), OptionalInt.empty(), target.useDepth ? target.getDepthTexture() : null, OptionalDouble.empty());){
                ImmediateRenderUtil.prepareRenderPass((RenderPass)renderPass, (RenderPipeline)renderPipeline);
                renderPass.drawMultipleIndexed(this.drawCallBuilder, null, null);
            }
            if (hasTextureFinalizer) {
                for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                    texture = this.texturesForDrawCalls.get(i);
                    textureFinalizer.accept(texture);
                }
            }
            textureBinder.accept(null);
            this.renderType.clearRenderState();
        }
        this.drawCallBuilder.clear();
        this.texturesForDrawCalls.clear();
        this.buffersForDrawCalls.clear();
        if (this.immediateVertexBuffer != null) {
            this.immediateVertexBuffer.clear();
        }
        this.used = false;
        this.renderType = null;
    }

    private RenderPass.Draw createDrawCall(MeshData meshData, GpuTexture texture, RenderPipeline renderPipeline) {
        ByteBuffer indexBuffer = meshData.indexBuffer();
        if (indexBuffer != null) {
            throw new IllegalArgumentException();
        }
        GpuBufferSlice gpuVertexBufferSlice = this.uploadImmediateVertexBuffer(meshData.vertexBuffer());
        long sliceOffset = gpuVertexBufferSlice.start();
        int sliceOffsetInVertices = (int)(sliceOffset / (long)this.renderType.format().getVertexSize());
        int firstIndex = this.renderType.mode().indexCount(sliceOffsetInVertices);
        RenderSystem.AutoStorageIndexBuffer sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)this.renderType.mode());
        GpuBuffer gpuIndexBuffer = sequentialBuffer.getBuffer(firstIndex + meshData.drawState().indexCount());
        VertexFormat.IndexType gpuIndexType = sequentialBuffer.type();
        return new RenderPass.Draw(0, gpuVertexBufferSlice.buffer(), gpuIndexBuffer, gpuIndexType, firstIndex, meshData.drawState().indexCount(), uu -> this.textureBinder.accept(texture));
    }

    private GpuBufferSlice uploadImmediateVertexBuffer(ByteBuffer vertexBuffer) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        if (this.immediateVertexBuffer == null) {
            this.immediateVertexBuffer = new DynamicImmediateGpuBuffer(vertexBuffer.remaining(), BufferType.VERTICES);
        }
        GpuBufferSlice slice = this.immediateVertexBuffer.allocateSlice(vertexBuffer.remaining());
        gpuDevice.createCommandEncoder().writeToBuffer(slice.buffer(), vertexBuffer, (int)slice.start());
        return slice;
    }

    private void endBuffer(BufferBuilder builder) {
        this.buffersForDrawCalls.add(builder.build());
    }

    public BufferBuilder begin(GpuTexture texture) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (texture == null) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture null!");
        }
        if (texture != this.prevTexture) {
            if (this.prevTexture != null) {
                this.endBuffer(this.currentBufferBuilder);
            }
            this.currentBufferBuilder = new BufferBuilder(this.sharedBuffer, this.renderType.mode(), this.renderType.format());
            this.prevTexture = texture;
            this.texturesForDrawCalls.add(texture);
        }
        return this.currentBufferBuilder;
    }
}

