/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import xaero.common.HudMod;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;

public class ClientEventsNeoForge
extends ClientEvents {
    public ClientEventsNeoForge(HudMod modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setNewScreen(gui);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGuiEvent.Pre event) {
        this.handleRenderGameOverlayEventPre(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPost(RenderGuiEvent.Post event) {
        this.handleRenderGameOverlayEventPost();
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type() && this.handleRenderStatusEffectOverlay(event.getGuiGraphics())) {
            event.setCanceled(true);
        }
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && this.handleRenderCrosshairOverlay(event.getGuiGraphics())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type()) {
            XaeroMinimapCore.onRenderStatusEffectOverlayPost(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChatEvent(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return;
        }
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        if (gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleRenderSolidBlocks(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
            XaeroMinimapCore.onWorldModelViewMatrix(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.worldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleClientTickStart();
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handlePlayerTickStart(event.player);
        }
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleRenderTickStart();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleBossHealthRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        XaeroMinimapCore.onBossHealthRender(event.getY() + event.getIncrement());
    }
}

