/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Matrix3x2fStack;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.controls.key.MinimapKeyMappings;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;
    private Button renderWaypointsButton;
    private Button showDisabledButton;
    private Button closeMenuWhenHoppingButton;
    private Button currentMapWaypointsButton;
    private Button renderAllSetsButton;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height, MinimapWorld waypointWorld, IXaeroMinimap modMain, MinimapSession minimapSession) {
        DropDownWidget setsDropdown;
        super.onMapInit(screen, mc, width, height);
        GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(true, waypointWorld) : null;
        IDropDownWidgetCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = (menu, selected) -> {
                if (selected == menu.size() - 1) {
                    GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (Screen)screen, (Screen)screen, waypointWorld);
                    Minecraft.getInstance().setScreen((Screen)guiNewSet);
                    return false;
                }
                sets.setCurrentSet(selected);
                waypointWorld.setCurrentWaypointSetId(sets.getCurrentSetKey());
                try {
                    minimapSession.getWorldManagerIO().saveWorld(waypointWorld);
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
                return true;
            };
        }
        DropDownWidget dropDownWidget = setsDropdown = sets == null ? null : DropDownWidget.Builder.begin().setOptions(sets.getOptions()).setX(width - 173).setY(height - 56).setW(151).setSelected(Integer.valueOf(sets.getCurrentSet())).setCallback(setsDropdownCallback).setContainer((IDropDownContainer)screen).setOpeningUp(true).setNarrationTitle((Component)Component.translatable((String)"gui.xaero_dropdown_waypoint_set")).build();
        if (setsDropdown != null) {
            screen.addWidget(setsDropdown);
        }
        MutableComponent fullWaypointMenuTooltipText = Component.translatable((String)"gui.xaero_box_full_waypoints_menu", (Object[])new Object[]{Component.literal((String)KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.WAYPOINT_MENU)).withStyle(ChatFormatting.DARK_GREEN)});
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean renderWaypoints = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        boolean showDisabledWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        boolean closeWaypointsWhenHopping = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        Tooltip fullWaypointMenuTooltip = new Tooltip((Component)fullWaypointMenuTooltipText, true);
        Tooltip onlyCurrentMapWaypointsTooltip = new Tooltip(onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", Style.EMPTY, true);
        Tooltip renderingWaypointsTooltip = new Tooltip((Component)Component.translatable((String)(renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints"), (Object[])new Object[]{Component.literal((String)KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.TOGGLE_MAP_WAYPOINTS)).withStyle(ChatFormatting.DARK_GREEN)}), true);
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean renderAllSetsConfig = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS);
        Tooltip renderAllSetsTooltip = new Tooltip((Component)Component.translatable((String)(!renderAllSetsConfig ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets"), (Object[])new Object[]{Component.literal((String)KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.RENDER_ALL_SETS)).withStyle(ChatFormatting.DARK_GREEN)}), true);
        Tooltip showingDisabledTooltip = new Tooltip(showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", Style.EMPTY, true);
        Tooltip closeWhenHoppingTooltip = new Tooltip(closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", Style.EMPTY, true);
        screen.addButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), () -> fullWaypointMenuTooltip, 256, 256));
        this.currentMapWaypointsButton = new GuiTexturedButton(width - 153, height - 20, 20, 20, onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, b -> this.onCurrentMapWaypointsButton(b, screen, width, height), () -> onlyCurrentMapWaypointsTooltip, 256, 256);
        screen.addButton(this.currentMapWaypointsButton);
        this.renderWaypointsButton = new GuiTexturedButton(width - 133, height - 20, 20, 20, renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onRenderWaypointsButton(screen, width, height), () -> renderingWaypointsTooltip, 256, 256);
        screen.addButton(this.renderWaypointsButton);
        this.renderAllSetsButton = new GuiTexturedButton(width - 113, height - 20, 20, 20, !renderAllSetsConfig ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), () -> renderAllSetsTooltip, 256, 256);
        screen.addButton(this.renderAllSetsButton);
        this.showDisabledButton = new GuiTexturedButton(width - 93, height - 20, 20, 20, showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), () -> showingDisabledTooltip, 256, 256);
        screen.addButton(this.showDisabledButton);
        this.closeMenuWhenHoppingButton = new GuiTexturedButton(width - 73, height - 20, 20, 20, closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), () -> closeWhenHoppingTooltip, 256, 256);
        screen.addButton(this.closeMenuWhenHoppingButton);
        this.renderWaypointsButton.active = !WorldMapClientConfigUtils.isOptionServerEnforced((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        screen.init(width, height);
        screen.setFocused((GuiEventListener)this.renderWaypointsButton);
    }

    private void onFullMenuButton(Button b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(Button b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(MinimapKeyMappings.RENDER_ALL_SETS, screen);
        screen.setFocused((GuiEventListener)this.renderAllSetsButton);
    }

    private void onShowDisabledButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        screen.init(width, height);
        screen.setFocused((GuiEventListener)this.showDisabledButton);
    }

    private void onCloseMenuWhenHoppingButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        screen.init(width, height);
        screen.setFocused((GuiEventListener)this.closeMenuWhenHoppingButton);
    }

    private void onCurrentMapWaypointsButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        screen.init(width, height);
        screen.setFocused((GuiEventListener)this.currentMapWaypointsButton);
    }

    @Override
    public void renderInMenu(Waypoint element, GuiGraphics guiGraphics, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        matrixStack.translate(-4.0f, -4.0f);
        if (type == 1) {
            guiGraphics.fill(0, 0, 9, 9, color);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Waypoint.minimapTextures, 1, 1, 0.0f, 78.0f, 9, 9, 256, 256, -16119286);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Waypoint.minimapTextures, 0, 0, 0.0f, 78.0f, 9, 9, 256, 256, -197380);
        } else {
            guiGraphics.fill(0, 0, 9, 9, color);
        }
        if (type != 1) {
            guiGraphics.drawString(mc.font, symbol, 5 - mc.font.width(symbol) / 2, 1, -1);
        }
        int infoIconOffset = 10;
        if (disabled) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WorldMap.guiTextures, textX - 1 - infoIconOffset, 0, 173.0f, 16.0f, 8, 8, 256, 256, -256);
            infoIconOffset += 10;
        }
        if (temporary) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WorldMap.guiTextures, textX - 1 - infoIconOffset, 0, 165.0f, 16.0f, 8, 8, 256, 256, -65536);
            infoIconOffset += 10;
        }
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected ElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

