/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.config.listener.handler;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import xaero.lib.client.config.listener.ClientConfigChangeListener;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;

public class WorldMapConfigOptionClientHandlers {
    private static void handleBlockColors(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleTerrainDepth(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleTerrainSlopes(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleBiomeBlending(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleBiomesInVanilla(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleAdjustShortBlockHeight(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleStainedGlass(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleLegibleCaveMaps(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleFlowers(Config config) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        WorldMapSession session = WorldMapSession.getCurrentSession();
        if (session != null) {
            session.getMapProcessor().getMapWriter().setDirtyInWriteDistance((EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearAllCachedHighlightHashes() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return;
        }
        Object object = worldmapSession.getMapProcessor().uiSync;
        synchronized (object) {
            worldmapSession.getMapProcessor().getMapWorld().clearAllCachedHighlightHashes();
        }
    }

    private static void handleOpacClaims(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleOpacClaimFillOpacity(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleOpacClaimBorderOpacity(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleReloadViewed(Config config) {
        if (((Boolean)config.get((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED)).booleanValue()) {
            config.set(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION, (Object)((Integer)config.get(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION) + 1));
        }
    }

    private static void handleMapItem(Config config) {
        WorldMapSession session = WorldMapSession.getCurrentSession();
        if (session != null) {
            session.getMapProcessor().updateMapItem();
        }
    }

    public static void registerAll(ClientConfigChangeListener registry) {
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BLOCK_COLORS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleBlockColors(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_DEPTH, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleTerrainDepth(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_SLOPES, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleTerrainSlopes(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BIOME_BLENDING, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleBiomeBlending(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BIOME_COLORS_IN_VANILLA, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleBiomesInVanilla(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleAdjustShortBlockHeight(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.STAINED_GLASS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleStainedGlass(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.LEGIBLE_CAVE_MAPS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleLegibleCaveMaps(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleFlowers(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleOpacClaims(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_FILL_OPACITY, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleOpacClaimFillOpacity(config);
            }
        });
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_BORDER_OPACITY, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleOpacClaimBorderOpacity(config);
            }
        });
        registry.register((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleReloadViewed(config);
            }
        });
        registry.register(WorldMapProfiledConfigOptions.MAP_ITEM, (Consumer)new Consumer<Config>(){

            @Override
            public void accept(Config config) {
                WorldMapConfigOptionClientHandlers.handleMapItem(config);
            }
        });
    }
}

