/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.Config;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private GuiButton caveModeStartSlider;
    private GuiTextField caveModeStartField;
    private String caveModeStartFieldPlaceholder;

    public void onInit(final GuiMap screen, MapProcessor mapProcessor) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = mapProcessor.getMapWorld().getFutureDimension();
        boolean bl = this.enabled = this.enabled && this.dimension != null && WorldMapClientConfigUtils.getEffectiveCaveModeAllowed();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            final Tooltip caveModeTypeButtonTooltip = new Tooltip("gui.xaero_wm_box_cave_mode_type");
            screen.addGuiButton((GuiButton)new TooltipButton(20, screen.field_146295_m - 62, 150, 20, this.getCaveModeTypeButtonMessage().func_150254_d(), new Supplier<Tooltip>(){

                @Override
                public Tooltip get() {
                    return caveModeTypeButtonTooltip;
                }
            }){

                public void onPress() {
                    GuiCaveModeOptions.this.onCaveModeTypeButton((GuiButton)this, screen);
                }
            });
        }
        this.caveModeStartFieldPlaceholder = I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(GuiButton b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.field_146126_j = this.getCaveModeTypeButtonMessage().func_150254_d();
    }

    private GuiTextField createField(final GuiMap screen) {
        GuiTextField field = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 172, screen.field_146295_m - 40, 50, 20);
        field.func_146203_f(7);
        int initialCaveModeStart = this.getCaveStart();
        field.func_146180_a(initialCaveModeStart == Integer.MAX_VALUE ? "" : initialCaveModeStart + "");
        field.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175319_a(int id, String text) {
                try {
                    GuiCaveModeOptions.this.setCaveStart(text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text));
                    GuiCaveModeOptions.this.updateSlider(screen);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175321_a(int id, boolean value) {
            }
        });
        return field;
    }

    private int getCaveStart() {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        return (Integer)primaryConfig.get(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
    }

    private void setCaveStart(int y) {
        Config primaryConfig = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager().getConfig();
        primaryConfig.set(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START, (Object)y);
        WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManagerIO().save();
    }

    private GuiButton createSlider(final GuiMap screen) {
        final String displayName = I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start", (Object[])new Object[0]);
        Supplier<String> labelGetter = new Supplier<String>(){

            @Override
            public String get() {
                return displayName;
            }
        };
        int initialCaveStart = this.getCaveStart();
        int minY = 0;
        int maxY = 255;
        final int minOption = minY - 1;
        final int range = maxY - minOption;
        double initialSliderValue = MathHelper.func_151237_a((double)((double)(initialCaveStart - minOption) / (double)range), (double)0.0, (double)1.0);
        return new XaeroSliderWidget(20, screen.field_146295_m - 40, 150, 20, (String)labelGetter.get(), initialSliderValue, new DoubleConsumer(){

            @Override
            public void accept(double newSliderValue) {
                int selectedY = (int)Math.round(newSliderValue * (double)range) + minOption;
                if (selectedY == minOption) {
                    selectedY = Integer.MAX_VALUE;
                }
                GuiCaveModeOptions.this.setCaveStart(selectedY);
                screen.onCaveModeStartSet();
            }
        }, (Supplier)labelGetter, screen.field_146294_l);
    }

    private void updateField(GuiMap screen) {
        this.caveModeStartField = this.createField(screen);
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addGuiButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMapClientConfigUtils.getEffectiveCaveModeAllowed() && !this.enabled;
        screen.func_146280_a(Minecraft.func_71410_x(), screen.field_146294_l, screen.field_146295_m);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.enabled) {
            this.caveModeStartField.func_146178_a();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.func_146195_b(false);
        }
    }

    private ITextComponent getCaveModeTypeButtonMessage() {
        return new TextComponentString(I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0]));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiTextField getCaveModeStartField() {
        return this.caveModeStartField;
    }

    public void postMapRender(GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        if (this.enabled) {
            boolean placeholder = this.caveModeStartField.func_146179_b().isEmpty();
            if (placeholder) {
                GuiUtils.setFieldText((GuiTextField)this.caveModeStartField, (String)this.caveModeStartFieldPlaceholder, (int)-11184811);
                this.caveModeStartField.func_146190_e(0);
            }
            this.caveModeStartField.func_146194_f();
            if (placeholder) {
                GuiUtils.setFieldText((GuiTextField)this.caveModeStartField, (String)"");
            }
        }
    }
}

