/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.packet.XaeroPacket;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.server.player.ServerPlayerData;

public class HandshakePacket
extends XaeroPacket {
    public static final int NETWORK_COMPATIBILITY = 3;
    private int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(3);
    }

    protected void write(PacketBuffer buf) {
        buf.writeInt(this.networkVersion);
    }

    protected void read(PacketBuffer buf) {
        this.networkVersion = buf.readInt();
    }

    public static class ServerHandler
    implements BiConsumer<HandshakePacket, EntityPlayerMP> {
        @Override
        public void accept(HandshakePacket message, EntityPlayerMP player) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements Consumer<HandshakePacket> {
        @Override
        public void accept(HandshakePacket message) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMapProcessor().setServerModNetworkVersion(message.networkVersion);
            WorldMap.messageHandler.sendToServer((XaeroPacket)new HandshakePacket());
        }
    }
}

