/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeGetter;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.region.OverlayManager;

public class MapWriterNeoForge
extends MapWriter {
    public MapWriterNeoForge(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        super(overlayManager, blockStateShortShapeCache, biomeGetter);
    }

    @Override
    protected boolean blockStateHasTranslucentRenderType(BlockState blockState) {
        BlockModelShaper bms = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BlockStateModel model = bms.getBlockModel(blockState);
        if (model == null) {
            return true;
        }
        this.reusableBlockModelPartList.clear();
        model.collectParts((BlockAndTintGetter)Minecraft.getInstance().level, new BlockPos(0, 0, 0), blockState, this.usedRandom, this.reusableBlockModelPartList);
        if (this.reusableBlockModelPartList.isEmpty()) {
            return false;
        }
        for (BlockModelPart blockModelPart : this.reusableBlockModelPartList) {
            if (blockModelPart.getRenderType(blockState) != ChunkSectionLayer.TRANSLUCENT) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<BakedQuad> getQuads(BlockStateModel model, Level level, BlockPos pos, BlockState state, Direction direction) {
        this.reusableBlockModelPartList.clear();
        model.collectParts((BlockAndTintGetter)level, pos, state, this.usedRandom, this.reusableBlockModelPartList);
        if (this.reusableBlockModelPartList.isEmpty()) {
            return null;
        }
        return ((BlockModelPart)this.reusableBlockModelPartList.getFirst()).getQuads(direction);
    }

    @Override
    protected TextureAtlasSprite getParticleIcon(BlockModelShaper bms, BlockStateModel model, Level level, BlockPos pos, BlockState state) {
        return model.particleIcon((BlockAndTintGetter)level, pos, state);
    }
}

