/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.minimap.highlight.DimensionHighlighterHandler;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.lib.common.util.KeySortableByOther;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.gui.GuiMap;
import xaero.map.misc.Misc;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointRenderer;
import xaero.map.mods.minimap.element.RadarRendererWrapperHelper;
import xaero.map.mods.minimap.tracker.system.MinimapSyncedPlayerTrackerSystem;
import xaero.map.radar.tracker.system.IPlayerTrackerSystem;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class SupportXaeroMinimap {
    IXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointWorld mapWaypointWorld;
    private class_5321<class_1937> mapDimId;
    private double dimDiv;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private WaypointMenuRenderer waypointMenuRenderer;
    private final WaypointRenderer waypointRenderer;
    private IPlayerTrackerSystem<?> minimapSyncedPlayerTrackerSystem;
    private WaypointWorld mouseBlockWaypointWorld;
    private WaypointWorld rightClickWaypointWorld;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = XaeroMinimapCore.modMain;
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = XaeroMinimapCore.modMain;
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
        this.waypointRenderer = WaypointRenderer.Builder.begin().setMinimap(this).setSymbolCreator(WorldMap.waypointSymbolCreator).build();
    }

    public void register() {
        if (this.hasTrackedPlayerSystemSupport()) {
            WorldMap.playerTrackerSystemManager.register("minimap_synced", this.getMinimapSyncedPlayerTrackerSystem());
        }
    }

    public ArrayList<Waypoint> convertWaypoints(double dimDiv) {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result, dimDiv);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result, dimDiv);
            }
        }
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        this.deathpoints = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.DEATHPOINTS);
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result, double dimDiv) {
        ArrayList list = set.getList();
        String setName = set.getName();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean showingDisabled = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            if (!showingDisabled && w.isDisabled()) continue;
            result.add(this.convertWaypoint(w, true, setName, dimDiv));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName, double dimDiv) {
        int waypointType = 0;
        waypointType = this.compatibilityVersion < 9 ? w.getType() : w.getWaypointType();
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), MinimapConfigConstants.COLORS[w.getColor()], waypointType, editable, setName, this.compatibilityVersion < 7 ? true : w.isYIncluded(), dimDiv);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, waypoint.getSetName()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z, double coordDimensionScale, boolean rightClick) {
        GuiAddWaypoint addScreen;
        WaypointWorld coordSourceWaypointWorld;
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorld waypointWorld = coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        if (this.hasDimSwitchSupport()) {
            addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, x, y, z, coordDimensionScale, coordSourceWaypointWorld);
        } else {
            int legacyX = x;
            int legacyY = y;
            int legacyZ = z;
            if (coordDimensionScale != class_310.method_1551().field_1687.method_8597().comp_646()) {
                double legacyDimDiv = class_310.method_1551().field_1687.method_8597().comp_646() / coordDimensionScale;
                legacyX = (int)Math.floor((double)legacyX / legacyDimDiv);
                legacyZ = (int)Math.floor((double)legacyZ / legacyDimDiv);
            }
            if (coordSourceWaypointWorld != this.waypointWorld) {
                legacyY = Short.MAX_VALUE;
            }
            if (this.compatibilityVersion < 8) {
                double dimDiv = this.compatibilityVersion < 2 ? (waypointsManager.divideBy8(this.waypointWorld.getContainer().getKey()) ? 8.0 : 1.0) : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
                xaero.common.minimap.waypoints.Waypoint w = this.compatibilityVersion >= 7 && legacyY == Short.MAX_VALUE ? new xaero.common.minimap.waypoints.Waypoint((int)Math.floor((double)legacyX * dimDiv), legacyY, (int)Math.floor((double)legacyZ * dimDiv), "", "", -1, 0, false, false) : new xaero.common.minimap.waypoints.Waypoint((int)Math.floor((double)legacyX * dimDiv), legacyY, (int)Math.floor((double)legacyZ * dimDiv), "", "", -1);
                addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
            } else {
                addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, legacyX, legacyY, legacyZ);
            }
        }
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public boolean canCreateWaypoint(int y, boolean rightClick) {
        WaypointWorld coordSourceWaypointWorld;
        if (this.compatibilityVersion > 6) {
            return true;
        }
        WaypointWorld waypointWorld = coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        if (coordSourceWaypointWorld != this.waypointWorld) {
            return false;
        }
        return y != Short.MAX_VALUE;
    }

    public boolean canShareLocation(int y) {
        return y != Short.MAX_VALUE || this.compatibilityVersion > 6;
    }

    public void createTempWaypoint(int x, int y, int z, double mapDimensionScale, boolean rightClick) {
        WaypointWorld coordSourceWaypointWorld;
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorld waypointWorld = coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        if (this.hasDimSwitchSupport()) {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z, y != Short.MAX_VALUE && coordSourceWaypointWorld == this.waypointWorld, mapDimensionScale);
        } else {
            int legacyX = x;
            int legacyY = y;
            int legacyZ = z;
            if (mapDimensionScale != class_310.method_1551().field_1687.method_8597().comp_646()) {
                double legacyDimDiv = class_310.method_1551().field_1687.method_8597().comp_646() / mapDimensionScale;
                legacyX = (int)Math.floor((double)legacyX / legacyDimDiv);
                legacyZ = (int)Math.floor((double)legacyZ / legacyDimDiv);
            }
            if (coordSourceWaypointWorld != this.waypointWorld) {
                legacyY = Short.MAX_VALUE;
            }
            if (this.compatibilityVersion >= 7 && legacyY == Short.MAX_VALUE) {
                waypointsManager.createTemporaryWaypoints(this.waypointWorld, legacyX, legacyY, legacyZ, false);
            } else {
                waypointsManager.createTemporaryWaypoints(this.waypointWorld, legacyX, legacyY, legacyZ);
            }
        }
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport(WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return world != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(world), world);
    }

    public void teleportToWaypoint(class_437 screen, Waypoint w) {
        this.teleportToWaypoint(screen, w, this.waypointWorld);
    }

    public void teleportToWaypoint(class_437 screen, Waypoint w, WaypointWorld world) {
        if (world == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), world, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointMenuRenderer.updateFilteredList();
    }

    public void checkWaypoints(boolean multiplayer, class_5321<class_1937> dimId, String multiworldId, int width, int height, GuiMap screen, MapWorld mapWorld, class_2378<class_2874> dimensionTypes) {
        ClientConfigManager minimapConfigManager;
        boolean renderAllSetsConfig;
        WaypointSet checkingSet;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        String containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId);
        String mapBasedMW = !multiplayer ? "waypoints" : multiworldId;
        this.mapWaypointWorld = waypointsManager.getWorld(containerId, mapBasedMW);
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        WaypointWorld checkingWaypointWorld = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS) != false ? this.mapWaypointWorld : waypointsManager.getCurrentWorld();
        class_310 mc = class_310.method_1551();
        if (this.compatibilityVersion >= 4 && Misc.hasEffect((class_1657)mc.field_1724, Effects.NO_WAYPOINTS)) {
            checkingWaypointWorld = null;
        } else if (this.compatibilityVersion >= 5 && (Misc.hasEffect((class_1657)mc.field_1724, Effects.NO_WAYPOINTS_BENEFICIAL) || Misc.hasEffect((class_1657)mc.field_1724, Effects.NO_WAYPOINTS_HARMFUL))) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (dimId != this.mapDimId) {
            shouldRefresh = true;
            this.mapDimId = dimId;
        }
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.method_25423(class_310.method_1551(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != (renderAllSetsConfig = ((Boolean)(minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager()).getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS)).booleanValue())) {
            this.allSets = renderAllSetsConfig;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.dimDiv = this.waypointWorld == null ? 1.0 : this.getDimensionDivision(mapWorld, dimensionTypes, waypointsManager, this.waypointWorld.getContainer().getKey(), dimId);
            this.waypoints = this.convertWaypoints(this.dimDiv);
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther> sortingList = new ArrayList<KeySortableByOther>();
                for (Waypoint w : this.waypoints) {
                    sortingList.add(new KeySortableByOther((Object)w, new Comparable[]{w.getComparisonName(), w.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther e : sortingList) {
                    this.waypointsSorted.add((Waypoint)e.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.waypointMenuRenderer.updateFilteredList();
        }
        this.refreshWaypoints = false;
    }

    private double getDimensionDivision(MapWorld mapWorld, class_2378<class_2874> dimensionTypes, WaypointsManager waypointsManager, String worldContainerID, class_5321<class_1937> mapDimId) {
        if (worldContainerID == null || class_310.method_1551().field_1687 == null) {
            return 1.0;
        }
        String dimPart = worldContainerID.substring(worldContainerID.lastIndexOf(47) + 1);
        class_5321 waypointDimId = waypointsManager.getDimensionKeyForDirectoryName(dimPart);
        MapDimension waypointMapDimension = mapWorld.getDimension((class_5321<class_1937>)waypointDimId);
        MapDimension mapDimension = mapWorld.getDimension(mapDimId);
        class_2874 waypointDimType = MapDimension.getDimensionType(waypointMapDimension, (class_5321<class_1937>)waypointDimId, dimensionTypes);
        class_2874 mapDimType = MapDimension.getDimensionType(mapDimension, mapDimId, dimensionTypes);
        double waypointDimScale = waypointDimType == null ? 1.0 : waypointDimType.comp_646();
        double mapDimScale = mapDimType == null ? 1.0 : mapDimType.comp_646();
        return mapDimScale / waypointDimScale;
    }

    public HoveredMapElementHolder<?, ?> renderWaypointsMenu(class_4587 matrixStack, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> hovered, class_310 mc) {
        return this.waypointMenuRenderer.renderMenu(matrixStack, gui, scale, width, height, mouseX, mouseY, leftMousePressed, leftMouseClicked, hovered, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public class_304 getWaypointKeyBinding() {
        return ModSettings.newWaypoint;
    }

    public class_304 getTempWaypointKeyBinding() {
        return ModSettings.keyInstantWaypoint;
    }

    public class_304 getTempWaypointsMenuKeyBinding() {
        return ModSettings.keyWaypoints;
    }

    public void onMapKeyPressed(class_3675.class_307 type, int code, GuiMap screen) {
        class_304 listPlayerAlternative;
        class_304 minimapSettingsKB;
        class_304 kb = null;
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)this.getToggleRadarKey(), (int)0)) {
            screen.onRadarButton(screen.getRadarButton());
        }
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keyToggleMapWaypoints, (int)0)) {
            this.getWaypointMenuRenderer().onRenderWaypointsButton(screen, screen.field_22789, screen.field_22790);
        }
        if (this.compatibilityVersion >= 8 && KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keyReverseEntityRadar, (int)0)) {
            ModSettings.keyReverseEntityRadar.method_23481(true);
        }
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keySwitchSet, (int)0)) {
            kb = ModSettings.keySwitchSet;
        }
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keyAllSets, (int)0)) {
            kb = ModSettings.keyAllSets;
        }
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keyWaypoints, (int)0)) {
            kb = ModSettings.keyWaypoints;
        }
        if (KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)(minimapSettingsKB = (class_304)this.modMain.getSettingsKey()), (int)0)) {
            kb = minimapSettingsKB;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)listPlayerAlternative, (int)0)) {
            listPlayerAlternative.method_23481(true);
        }
        class_310 mc = class_310.method_1551();
        if (kb != null) {
            if (kb == ModSettings.keyWaypoints) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                mc.method_1507(this.getSettingsScreen((class_437)screen));
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public boolean onMapKeyReleased(class_3675.class_307 type, int code, GuiMap screen) {
        class_304 listPlayerAlternative;
        boolean result = false;
        if (this.compatibilityVersion >= 8 && KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)ModSettings.keyReverseEntityRadar, (int)0)) {
            ModSettings.keyReverseEntityRadar.method_23481(false);
            result = true;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && KeyMappingUtils.inputMatches((class_3675.class_307)type, (int)code, (class_304)listPlayerAlternative, (int)0)) {
            listPlayerAlternative.method_23481(false);
            result = true;
        }
        return result;
    }

    public void handleMinimapKeyBinding(class_304 kb, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getControls().keyDown(kb, false, false);
        if ((kb == ModSettings.keySwitchSet || kb == ModSettings.keyAllSets) && screen.waypointMenu) {
            screen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
        }
    }

    public void drawSetChange(class_4587 matrixStack) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), matrixStack, class_310.method_1551().method_22683());
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }

    public class_437 getSettingsScreen(class_437 current) {
        return this.modMain.getGuiHelper().getMinimapSettingsFromScreen(current);
    }

    public String getControlsTooltip() {
        return class_1074.method_4662((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{KeyMappingUtils.getKeyName((class_304)ModSettings.newWaypoint), KeyMappingUtils.getKeyName((class_304)ModSettings.keyInstantWaypoint), KeyMappingUtils.getKeyName((class_304)ModSettings.keySwitchSet), KeyMappingUtils.getKeyName((class_304)ModSettings.keyAllSets), KeyMappingUtils.getKeyName((class_304)ModSettings.keyWaypoints)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer(new WaypointMenuRenderContext(), new WaypointMenuRenderProvider(this), this.waypointRenderer);
    }

    public void onMapInit(GuiMap mapScreen, class_310 mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, mc, width, height, this.waypointWorld, this.modMain, XaeroMinimapSession.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsSorted() {
        return this.waypointsSorted;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void openWaypointsMenu(class_310 mc, GuiMap screen) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession.getWorldState().getAutoWorldPath() == null) {
            return;
        }
        mc.method_1507((class_437)new GuiWaypoints(HudMod.INSTANCE, minimapSession, (class_437)screen, (class_437)screen));
    }

    public boolean hidingWaypointCoordinates() {
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        return (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.HIDE_WAYPOINT_COORDINATES);
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen, WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getWaypointSharing().shareWaypoint((class_437)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), world);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)MinimapConfigConstants.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = this.compatibilityVersion < 7 ? new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY, rightClickZ, "Shared Location", "S", wpColor) : new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == Short.MAX_VALUE ? 0 : rightClickY, rightClickZ, "Shared Location", "S", wpColor, 0, false, rightClickY != Short.MAX_VALUE);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "", 1.0);
        this.shareWaypoint(locationWaypoint, guiMap, this.rightClickWaypointWorld);
    }

    public WaypointWorld getMapWaypointWorld() {
        return this.mapWaypointWorld;
    }

    public WaypointWorld getWaypointWorld() {
        return this.waypointWorld;
    }

    public double getDimDiv() {
        return this.dimDiv;
    }

    public int getArrowColorIndex() {
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        return (Integer)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_COLOR);
    }

    public float[] getArrowColor() {
        int arrowColour = this.getArrowColorIndex();
        if (arrowColour < 0 || arrowColour >= MinimapConfigConstants.ARROW_COLORS.length) {
            return null;
        }
        return MinimapConfigConstants.ARROW_COLORS[arrowColour];
    }

    public String getSubWorldNameToRender() {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        if (onlyCurrentMapWaypoints || this.waypointWorld == null) {
            return null;
        }
        if (this.waypointWorld != this.mapWaypointWorld) {
            return class_1074.method_4662((String)"gui.xaero_wm_using_custom_subworld", (Object[])new Object[]{this.waypointWorld.getContainer().getSubName()});
        }
        return null;
    }

    public void registerMinimapHighlighters(Object highlighterRegistry) {
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public boolean getDeathpoints() {
        return this.deathpoints;
    }

    public WaypointRenderer getWaypointRenderer() {
        return this.waypointRenderer;
    }

    public WaypointMenuRenderer getWaypointMenuRenderer() {
        return this.waypointMenuRenderer;
    }

    public void onClearHighlightHash(int regionX, int regionZ) {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession;
        if (this.compatibilityVersion >= 11 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh(regionX, regionZ);
        }
    }

    public void createRadarRendererWrapper(Object radarRenderer) {
        new RadarRendererWrapperHelper().createWrapper(this.modMain, (RadarRenderer)radarRenderer);
    }

    public class_304 getToggleRadarKey() {
        if (this.compatibilityVersion < 10) {
            return null;
        }
        return ModSettings.keyToggleRadar;
    }

    public void onClearHighlightHashes() {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession;
        if (this.compatibilityVersion >= 13 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh();
        }
    }

    public class_304 getToggleAllyPlayersKey() {
        if (this.compatibilityVersion < 14) {
            return null;
        }
        if (this.hasTrackedPlayerSystemSupport()) {
            return ModSettings.keyToggleTrackedPlayers;
        }
        return ModSettings.keyTogglePacPlayers;
    }

    public class_304 getToggleClaimsKey() {
        if (this.compatibilityVersion < 14) {
            return null;
        }
        return ModSettings.keyTogglePacChunkClaims;
    }

    public boolean hasPacSupport() {
        return this.compatibilityVersion >= 14;
    }

    public void onSessionFinalized() {
        this.waypointWorld = null;
        this.mapWaypointWorld = null;
    }

    public void openWaypointWorldTeleportCommandScreen(class_437 parent, class_437 escape) {
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldRootContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID()).getRootContainer();
        if (container != null) {
            if (this.compatibilityVersion >= 15) {
                class_310.method_1551().method_1507((class_437)new GuiWorldTpCommand(this.modMain, parent, escape, container));
            } else {
                WaypointWorld firstWorld = container.getFirstWorld();
                if (firstWorld != null) {
                    class_310.method_1551().method_1507((class_437)new GuiWorldTpCommand(this.modMain, parent, escape, firstWorld));
                }
            }
        }
    }

    public class_304 getMinimapListPlayersAlternative() {
        if (this.compatibilityVersion < 16) {
            return null;
        }
        return ModSettings.keyAlternativeListPlayers;
    }

    public int getCaveStart(int defaultWorldMapStart, boolean isMapScreen) {
        if (!this.modMain.getSettings().getMinimap()) {
            return defaultWorldMapStart;
        }
        if (!MinimapConfigClientUtils.getEffectiveCaveModeAllowed()) {
            return isMapScreen ? defaultWorldMapStart : Integer.MAX_VALUE;
        }
        int usedCaving = this.getUsedCaving();
        if (usedCaving == Integer.MAX_VALUE) {
            ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
            SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
            return (Integer)primaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
        }
        return usedCaving;
    }

    public int getUsedCaving() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            return minimapSession.getMinimapProcessor().getMinimapWriter().getLoadedCaving();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isFairPlay() {
        return this.compatibilityVersion >= 8 && this.modMain.isFairPlay();
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 17;
    }

    public IPlayerTrackerSystem<?> getMinimapSyncedPlayerTrackerSystem() {
        if (this.minimapSyncedPlayerTrackerSystem == null) {
            this.minimapSyncedPlayerTrackerSystem = new MinimapSyncedPlayerTrackerSystem(this);
        }
        return this.minimapSyncedPlayerTrackerSystem;
    }

    public boolean hasDimSwitchSupport() {
        return this.compatibilityVersion >= 20;
    }

    public void onBlockHover() {
        this.mouseBlockWaypointWorld = this.mapWaypointWorld;
    }

    public void onRightClick() {
        this.rightClickWaypointWorld = this.mouseBlockWaypointWorld;
    }
}

