/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.channel.register.handler.IConfigChannelClientRegistryHandler;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.channel.register.ConfigChannelRegistry;
import xaero.lib.common.config.channel.register.handler.IConfigChannelCommonRegistryHandler;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.primary.option.LibPrimaryCommonConfigOptions;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketHandlerRegistry;
import xaero.lib.patreon.Patreon;
import xaero.lib.patreon.PatreonMod;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.biome.MapBiomes;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.common.config.LegacyCommonConfigIO;
import xaero.map.common.config.LegacyCommonConfigInit;
import xaero.map.common.config.channel.register.handler.WorldMapChannelCommonRegistryHandler;
import xaero.map.config.channel.register.handler.WorldMapChannelClientRegistryHandler;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.controls.ControlsRegister;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.events.ClientEvents;
import xaero.map.events.CommonEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.file.export.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.WorldMapMessageRegister;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.pool.buffer.TextureDirectBufferPool;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderer;
import xaero.map.radar.tracker.system.PlayerTrackerSystemManager;
import xaero.map.radar.tracker.system.impl.SyncedPlayerTrackerSystem;
import xaero.map.region.OverlayManager;
import xaero.map.server.WorldMapServer;
import xaero.map.server.core.XaeroWorldMapServerCore;
import xaero.map.server.mods.SupportServerMods;
import xaero.map.server.player.ServerPlayerTickHandler;
import xaero.map.settings.ModSettings;

@Mod(modid="xaeroworldmap", name="Xaero's World Map", guiFactory="xaero.map.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*", dependencies="required-after:xaerolib@[1.1.0,);before:xaerominimap@[25.3.2,);before:xaerobetterpvp@[25.3.2,);")
public class WorldMap {
    public static final Logger LOGGER = LogManager.getLogger();
    @Mod.Instance(value="xaeroworldmap")
    public static WorldMap INSTANCE;
    public static int MINIMAP_COMPATIBILITY_VERSION;
    private static final String versionID_minecraft = "1.12.2";
    public static String versionID;
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static boolean loaded;
    public static ClientEvents events;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static TextureUploadPool.SubsequentNormal subsequentNormalTextureUploadPool;
    public static TextureDirectBufferPool textureDirectBufferPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static MapBiomes mapBiomes;
    public static final ResourceLocation guiTextures;
    public static ModSettings settings;
    public static WorldMapClient worldMapClient;
    public static MapElementRenderHandler mapElementRenderHandler;
    public static ServerPlayerTickHandler serverPlayerTickHandler;
    public static PlayerTrackerSystemManager playerTrackerSystemManager;
    public static PlayerTrackerMapElementRenderer trackedPlayerRenderer;
    public static PlayerTrackerMenuRenderer trackedPlayerMenuRenderer;
    public static IPacketHandler messageHandler;
    public static CommonEvents commonEvents;
    public static ModCommonEvents modCommonEvents;
    private Path configSubFolder;
    private Path defaultConfigsSubFolder;
    private boolean shouldLoadLegacySettings;
    private ConfigChannel configChannel;
    public static boolean detailed_debug;
    public static boolean pauseRequests;
    public static boolean extraDebug;
    public static LegacyCommonConfigIO commonConfigIO;
    private WorldMapServer worldmapServer;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        versionID = "1.12.2_" + event.getModMetadata().version;
        String modId = this.getClass().getAnnotation(Mod.class).modid();
        configFolder = event.getModConfigurationDirectory();
        this.configSubFolder = configFolder.toPath().resolve("xaero").resolve("world-map");
        this.defaultConfigsSubFolder = configFolder.toPath().resolveSibling("defaultconfigs").resolve("xaero").resolve("world-map");
        this.shouldLoadLegacySettings = !Files.exists(this.configSubFolder, new LinkOption[0]);
        this.configChannel = ConfigChannel.Builder.begin().setId(new ResourceLocation(modId, "main")).setCommonRegistryHandler((IConfigChannelCommonRegistryHandler)new WorldMapChannelCommonRegistryHandler()).setClientRegistryHandlerSupplier((Supplier)new Supplier<IConfigChannelClientRegistryHandler>(){

            @Override
            public IConfigChannelClientRegistryHandler get() {
                return new WorldMapChannelClientRegistryHandler();
            }
        }).setLogger(LOGGER).setConfigPath(this.configSubFolder).setDefaultConfigsPath(this.defaultConfigsSubFolder).setDefaultEnforcedServerProfileNodePath("xaero.world_map.enforced_server_profile").build();
        ConfigChannelRegistry.INSTANCE.register(this.configChannel);
        new LegacyCommonConfigInit().init(event.getSide() == Side.SERVER, event.getModConfigurationDirectory().toPath(), "xaeroworldmap-common.txt");
        commonEvents = new CommonEvents();
        modCommonEvents = new ModCommonEvents();
        MinecraftForge.EVENT_BUS.register((Object)commonEvents);
        MinecraftForge.EVENT_BUS.register((Object)modCommonEvents);
        if (event.getSide() == Side.SERVER) {
            return;
        }
        trackedPlayerRenderer = PlayerTrackerMapElementRenderer.Builder.begin().build();
        trackedPlayerMenuRenderer = PlayerTrackerMenuRenderer.Builder.begin().setRenderer(trackedPlayerRenderer).build();
        worldMapClient = new WorldMapClient();
        worldMapClient.preInit(event, modId);
        if (event.getSourceFile().getName().endsWith(".jar")) {
            modJAR = event.getSourceFile();
        }
        Path gameDir = WorldMap.getGameDir();
        optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
        Path oldSaveFolder4 = gameDir.resolve("XaeroWorldMap");
        Path xaeroFolder = gameDir.resolve("xaero");
        if (!Files.exists(xaeroFolder, new LinkOption[0])) {
            Files.createDirectories(xaeroFolder, new FileAttribute[0]);
        }
        saveFolder = xaeroFolder.resolve("world-map").toFile();
        if (oldSaveFolder4.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder4, saveFolder.toPath(), new CopyOption[0]);
        }
        Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
        File oldOptionsFile = gameDir.resolve("xaeroworldmap.txt").toFile();
        File oldSaveFolder = gameDir.resolve("mods").resolve("XaeroWorldMap").toFile();
        File oldSaveFolder2 = gameDir.resolve("config").resolve("XaeroWorldMap").toFile();
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        messageHandler = PacketHandlerRegistry.INSTANCE.register(new ResourceLocation("xaeroworldmap", "main"), 1000000, "1.0");
        new WorldMapMessageRegister().register(messageHandler);
        serverPlayerTickHandler = new ServerPlayerTickHandler();
        SupportServerMods.check();
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer = new WorldMapServer();
            this.worldmapServer.load(event);
            return;
        }
        events = new ClientEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        waypointSymbolCreator = new WaypointSymbolCreator();
        controlsRegister = new ControlsRegister();
        ServerWorldCapabilities.registerCapabilities();
        bufferDeallocator = new ByteBufferDeallocator();
        tilePool = new MapTilePool();
        overlayManager = new OverlayManager();
        pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        mapLimiter = new MapLimiter();
        normalTextureUploadPool = new TextureUploadPool.Normal(256);
        compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
        branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
        branchDownloadPool = new TextureUploadPool.BranchDownload(256);
        textureDirectBufferPool = new TextureDirectBufferPool();
        subsequentNormalTextureUploadPool = new TextureUploadPool.SubsequentNormal(256);
        textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256, 256);
        glObjectDeleter = new GLObjectDeleter();
        crashHandler = new CrashHandler();
        mapBiomes = new MapBiomes();
        mapRunner = new MapRunner();
        mapRunnerThread = new Thread(mapRunner);
        mapRunnerThread.start();
    }

    void loadLaterCommon() {
        if (commonConfigIO.shouldEnableEveryoneTracksEveryone()) {
            XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryCommonConfigManager().getConfig().set((ConfigOption)LibPrimaryCommonConfigOptions.EVERYONE_TRACKS_EVERYONE, (Object)true);
        }
    }

    public static Path getGameDir() {
        return Minecraft.func_71410_x().field_71412_D.toPath().toAbsolutePath();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PatreonMod patreonEntry;
        this.loadLaterCommon();
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer.loadLater();
            this.worldmapServer = null;
            loaded = true;
            XaeroWorldMapServerCore.loaded = true;
            return;
        }
        settings = new ModSettings();
        if (this.shouldLoadLegacySettings) {
            try {
                settings.loadSettings();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.configChannel.getClientConfigProfileIO().save(this.configChannel.getClientConfigManager().getCurrentProfile());
            this.configChannel.getPrimaryClientConfigManagerIO().save();
        }
        settings.updateRegionCacheHashCode();
        Patreon.checkPatreon();
        Internet.checkModVersion();
        if (isOutdated && (patreonEntry = (PatreonMod)Patreon.getMods().get(fileLayoutID)) != null) {
            patreonEntry.modJar = modJAR;
            patreonEntry.currentVersion = versionID;
            patreonEntry.latestVersion = latestVersion;
            patreonEntry.md5 = latestVersionMD5;
            patreonEntry.onVersionIgnore = new Runnable(){

                @Override
                public void run() {
                    WorldMap.this.getConfigs().getPrimaryClientConfigManager().getConfig().set(WorldMapPrimaryClientConfigOptions.IGNORED_UPDATE, (Object)newestUpdateID);
                    WorldMap.this.getConfigs().getPrimaryClientConfigManagerIO().save();
                }
            };
            Patreon.addOutdatedMod((Object)patreonEntry);
        }
        playerTrackerSystemManager.register("map_synced", new SyncedPlayerTrackerSystem());
        SupportMods.load();
        mapElementRenderHandler = MapElementRenderHandler.Builder.begin().build();
        loaded = true;
        XaeroWorldMapCore.loaded = true;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        commonEvents.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        commonEvents.onServerStopped(event);
    }

    public static void onSessionFinalized() {
        mapLimiter.onSessionFinalized();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onSessionFinalized();
        }
    }

    public ConfigChannel getConfigs() {
        return this.configChannel;
    }

    static {
        MINIMAP_COMPATIBILITY_VERSION = 26;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        playerTrackerSystemManager = new PlayerTrackerSystemManager();
        detailed_debug = false;
        pauseRequests = false;
        extraDebug = false;
        modJAR = null;
    }
}

