/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Keyboard;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    protected String screenTitle;
    private MySmallButton confirmButton;
    private GuiTextField commandFormatTextField;
    private GuiTextField dimensionCommandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private String dimensionCommandFormat;
    private MapWorld mapWorld;

    public GuiMapTpCommand(GuiScreen parent, GuiScreen escape) {
        super(parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_wm_teleport_command", new Object[0]));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultMapTeleport();
        this.commandFormat = mapWorld.getTeleportCommandFormat();
        this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.screenTitle = I18n.func_135052_a((String)"gui.xaero_wm_teleport_command", (Object[])new Object[0]);
        WorldMapSession session = WorldMapSession.getCurrentSession();
        final MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        final String defaultMapTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT);
        final String defaultMapTeleportDimensionFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT);
        this.commandFormatTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7 + 60, 200, 20);
        this.commandFormatTextField.func_146203_f(500);
        this.commandFormatTextField.func_146180_a(this.usingDefault ? defaultMapTeleportFormat : this.commandFormat);
        this.dimensionCommandFormatTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7 + 90, 200, 20);
        this.dimensionCommandFormatTextField.func_146203_f(500);
        this.dimensionCommandFormatTextField.func_146180_a(this.usingDefault ? defaultMapTeleportDimensionFormat : this.dimensionCommandFormat);
        if (this.usingDefault) {
            this.commandFormatTextField.func_146184_c(false);
            this.dimensionCommandFormatTextField.func_146184_c(false);
            this.commandFormatTextField.func_146193_g(-11184811);
            this.dimensionCommandFormatTextField.func_146193_g(-11184811);
        } else {
            this.commandFormatTextField.func_175207_a(new GuiPageButtonList.GuiResponder(){

                public void func_175319_a(int id, String text) {
                    GuiMapTpCommand.this.commandFormat = text;
                }

                public void func_175320_a(int id, float value) {
                    this.func_175319_a(id, value + "");
                }

                public void func_175321_a(int id, boolean value) {
                    this.func_175319_a(id, value + "");
                }
            });
            this.dimensionCommandFormatTextField.func_175207_a(new GuiPageButtonList.GuiResponder(){

                public void func_175319_a(int id, String text) {
                    GuiMapTpCommand.this.dimensionCommandFormat = text;
                }

                public void func_175320_a(int id, float value) {
                    this.func_175319_a(id, value + "");
                }

                public void func_175321_a(int id, boolean value) {
                    this.func_175319_a(id, value + "");
                }
            });
        }
        this.textFields.add(this.commandFormatTextField);
        this.textFields.add(this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.func_189646_b((GuiButton)new MySmallButton(0, this.field_146294_l / 2 - 75, this.field_146295_m / 7 + 138, I18n.func_135052_a((String)"gui.xaero_wm_teleport_command_waypoints", (Object[])new Object[0])){

                protected void onPress() {
                    SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen((GuiScreen)GuiMapTpCommand.this, GuiMapTpCommand.this.escape);
                }
            });
        }
        this.confirmButton = new MySmallButton(1, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])){

            protected void onPress() {
                if (GuiMapTpCommand.this.canConfirm()) {
                    if (!GuiMapTpCommand.this.usingDefault && GuiMapTpCommand.this.commandFormat.equals(defaultMapTeleportFormat) && GuiMapTpCommand.this.dimensionCommandFormat.equals(defaultMapTeleportDimensionFormat)) {
                        GuiMapTpCommand.this.usingDefault = true;
                    }
                    mapWorld.setTeleportCommandFormat(GuiMapTpCommand.this.commandFormat);
                    mapWorld.setDimensionTeleportCommandFormat(GuiMapTpCommand.this.dimensionCommandFormat);
                    mapWorld.setUseDefaultMapTeleport(GuiMapTpCommand.this.usingDefault);
                    mapWorld.saveConfig();
                    GuiMapTpCommand.this.goBack();
                }
            }
        };
        this.func_189646_b((GuiButton)this.confirmButton);
        this.func_189646_b((GuiButton)new MySmallButton(2, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])){

            protected void onPress() {
                GuiMapTpCommand.this.goBack();
            }
        });
        this.func_189646_b((GuiButton)new MySmallButton(202, this.field_146294_l / 2 - 75, this.field_146295_m / 7 + 20, ConfigUtils.optionNameValue((ITextComponent)new TextComponentTranslation("gui.xaero_wm_use_default", new Object[0]), (ITextComponent)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault))){

            protected void onPress() {
                GuiMapTpCommand.this.usingDefault = !GuiMapTpCommand.this.usingDefault;
                GuiMapTpCommand.this.func_146280_a(GuiMapTpCommand.this.field_146297_k, GuiMapTpCommand.this.field_146294_l, GuiMapTpCommand.this.field_146295_m);
            }
        });
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(mouseX, mouseY, partial);
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        if (SupportMods.minimap()) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_wm_teleport_command_waypoints_hint", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 7 + 124, -5592406);
        }
        this.func_73732_a(this.field_146289_q, "{x} {y} {z} {d}", this.field_146294_l / 2, this.field_146295_m / 7 + 46, -5592406);
        super.func_73863_a(mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.confirmButton.field_146124_l = this.canConfirm();
    }

    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if ((par2 == 28 || par2 == 156) && this.canConfirm()) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
    }
}

