/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.CustomSettingEntry;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaero.map.MapFullReloader;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.WorldMapConfigConstants;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ConfirmScreenBase;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapTpCommand;
import xaero.map.gui.GuiPlayerTpCommand;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModSettings;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiWorldMapSettings
extends EditConfigScreen {
    public static final ITextComponent PLAYER_TELEPORT_COMMAND_TOOLTIP = new TranslationTextComponent("gui.xaero_wm_box_player_teleport_command");
    public static final ITextComponent MAP_TELEPORT_COMMAND_TOOLTIP = new TranslationTextComponent("gui.xaero_wm_box_map_teleport_command");

    public GuiWorldMapSettings(IEditConfigScreenContext context) {
        this(null, context);
    }

    public GuiWorldMapSettings(Screen parent, IEditConfigScreenContext context) {
        this(parent, null, context);
    }

    public GuiWorldMapSettings(Screen parent, Screen escapeScreen, IEditConfigScreenContext context) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_world_map_settings"), parent, escapeScreen, context, WorldMap.INSTANCE.getConfigs());
        ScreenSwitchSettingEntry minimapEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_minimap_settings", (current, escape) -> SupportMods.xaeroMinimap.getSettingsScreen((Screen)current), !SupportMods.minimap() ? new Tooltip(WorldMapConfigConstants.MINIMAP_TOOLTIP) : null, SupportMods.minimap());
        ScreenSwitchSettingEntry resetEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_reset_config_profile_default", (current, escape) -> new ConfirmScreenBase((Screen)current, (Screen)escape, true, r -> this.resetConfirmResult(r, (Screen)this, escapeScreen), (ITextComponent)new TranslationTextComponent("gui.xaero_wm_reset_config_profile_default_message"), (ITextComponent)new TranslationTextComponent("gui.xaero_wm_reset_config_profile_default_message2")), null, true, false);
        ScreenSwitchSettingEntry mapTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_teleport_command", (current, escape) -> new GuiMapTpCommand((Screen)current, (Screen)escape), new Tooltip(!context.isClientSide() ? GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT : (!ModSettings.canEditIngameSettings() ? WorldMapConfigConstants.INGAME_TOOLTIP : MAP_TELEPORT_COMMAND_TOOLTIP)), context.isClientSide() && ModSettings.canEditIngameSettings());
        ScreenSwitchSettingEntry playerTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_player_teleport_command", (current, escape) -> new GuiPlayerTpCommand((Screen)current, (Screen)escape), new Tooltip(!context.isClientSide() ? GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT : (!ModSettings.canEditIngameSettings() ? WorldMapConfigConstants.INGAME_TOOLTIP : PLAYER_TELEPORT_COMMAND_TOOLTIP)), context.isClientSide() && ModSettings.canEditIngameSettings());
        CustomSettingEntry ignoreHeightmapsEntry = new CustomSettingEntry(() -> false, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_ignore_heightmaps"), context.isClientSide() ? new TooltipInfo("gui.xaero_wm_box_ignore_heightmaps") : new TooltipInfo(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT, false, true), false, () -> {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return null;
            }
            return session.getMapProcessor().getMapWorld().isIgnoreHeightmaps();
        }, 0, 1, i -> i == 1, v -> v != false ? ConfigConstants.ON : ConfigConstants.OFF, (oldValue, newValue) -> {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            MapWorld mapWorld = session.getMapProcessor().getMapWorld();
            mapWorld.setIgnoreHeightmaps((boolean)newValue);
            mapWorld.saveConfig();
            WorldMap.settings.updateRegionCacheHashCode();
        }, () -> context.isClientSide() && WorldMapSession.getCurrentSession() != null);
        ISettingEntry fullReloadEntry = this.getEntryForFullReloadOption(false);
        ISettingEntry fullResaveEntry = this.getEntryForFullReloadOption(true);
        CustomSettingEntry pauseRequestsEntry = new CustomSettingEntry(() -> false, (ITextComponent)new StringTextComponent("Pause Requests"), null, false, () -> WorldMap.pauseRequests, 0, 1, i -> i == 1, v -> v != false ? ConfigConstants.ON : ConfigConstants.OFF, (o, n) -> {
            WorldMap.pauseRequests = n;
        }, () -> true);
        CustomSettingEntry extraDebugEntry = new CustomSettingEntry(() -> false, (ITextComponent)new StringTextComponent("Extra Debug"), null, false, () -> WorldMap.extraDebug, 0, 1, i -> i == 1, v -> v != false ? ConfigConstants.ON : ConfigConstants.OFF, (o, n) -> {
            WorldMap.extraDebug = n;
        }, () -> true);
        this.entries = new ISettingEntry[]{this.createProfileIDEntry(), this.optionEntry(BuiltInProfiledConfigOptions.PROFILE_NAME), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LIGHTING), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BLOCK_COLORS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LOAD_NEW_CHUNKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.UPDATE_CHUNKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_DEPTH), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_SLOPES), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.FOOTSTEPS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.COORDINATES), minimapEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MINIMAP_RADAR), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_BACKGROUNDS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_SCALE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BIOME_BLENDING), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BIOME_COLORS_IN_VANILLA), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MIN_ZOOM_LOCAL_WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.STAINED_GLASS), ignoreHeightmapsEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED), this.optionEntry(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.AUTO_CAVE_MODE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LEGIBLE_CAVE_MAPS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_TOGGLE_TIMER), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DEFAULT_CAVE_MODE_TYPE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_CAVE_MODE_START), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WRITING_DISTANCE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ARROW), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.OPENING_ANIMATION), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ARROW_COLOR), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_ZOOM), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_HOVERED_BIOME), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ZOOM_BUTTONS), this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT), this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT), mapTeleportCommandEntry, this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_PLAYER_TELEPORT_FORMAT), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DETECT_AMBIGUOUS_Y), playerTeleportCommandEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MAP_TELEPORT_ALLOWED), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT), this.optionEntry(WorldMapProfiledConfigOptions.MAP_ITEM), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS), this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED), fullReloadEntry, this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.UPDATE_NOTIFICATIONS), fullResaveEntry, this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.DEBUG), resetEntry, this.optionEntry((ConfigOption)BuiltInProfiledConfigOptions.IGNORE_ENFORCEMENT_IF_EDITOR)};
    }

    private ISettingEntry getEntryForFullReloadOption(boolean isResave) {
        return new CustomSettingEntry(() -> false, (ITextComponent)new TranslationTextComponent(isResave ? "gui.xaero_full_resave" : "gui.xaero_full_reload"), this.context.isClientSide() ? new TooltipInfo(isResave ? "gui.xaero_box_full_resave" : "gui.xaero_box_full_reload") : new TooltipInfo(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT, false, true), false, () -> {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return false;
            }
            MapDimension mapDimension = session.getMapProcessor().getMapWorld().getCurrentDimension();
            MapFullReloader reloader = mapDimension == null ? null : mapDimension.getFullReloader();
            return reloader != null && (!isResave || reloader.isResave());
        }, 0, 1, i -> i == 1, v -> v != false ? ConfigConstants.ON : ConfigConstants.OFF, (oldValue, newValue) -> {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = session.getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDimension == null) {
                return;
            }
            if (newValue.booleanValue() && (mapDimension.getFullReloader() == null || !mapDimension.getFullReloader().isResave() && isResave)) {
                mapDimension.startFullMapReload(mapProcessor.getCurrentCaveLayer(), isResave, mapProcessor);
            } else if (!newValue.booleanValue()) {
                mapDimension.clearFullMapReload();
            }
            this.refresh();
        }, () -> this.context.isClientSide() && WorldMapSession.getCurrentSession() != null);
    }

    protected void resetConfirmResult(boolean result, Screen parent, Screen escScreen) {
        if (result) {
            this.resetProfileToDefaults();
        }
        Minecraft.func_71410_x().func_147108_a(parent);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        Tooltip closeSettingsTooltip = new Tooltip((ITextComponent)new TranslationTextComponent("gui.xaero_box_close_settings", new Object[]{KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyOpenSettings)}));
        if (this.parent instanceof GuiMap) {
            this.func_230480_a_((Widget)new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, this::onSettingsButton, () -> closeSettingsTooltip));
        }
    }

    private void onSettingsButton(Widget button) {
        this.goBack();
    }

    public boolean func_231046_a_(int key, int scancode, int mods) {
        if (super.func_231046_a_(key, scancode, mods)) {
            return true;
        }
        if (this.context.isClientSide() && KeyMappingUtils.inputMatches((InputMappings.Type)InputMappings.Type.KEYSYM, (int)key, (KeyBinding)ControlsRegister.keyOpenSettings, (int)0) || !this.context.isClientSide() && KeyMappingUtils.inputMatches((InputMappings.Type)InputMappings.Type.KEYSYM, (int)key, (KeyBinding)ControlsRegister.keyOpenServerSettings, (int)0)) {
            this.onExit(this.escape);
            return true;
        }
        return false;
    }
}

