/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTSeparateShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;

public class Misc {
    private static final long[] ZERO_LONG_586 = new long[586];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    public static final String OUTDATED_FILE_EXT = ".outdated";
    private static int shadersType;
    private static boolean EXTgeometryShader;

    public static BlockState getStateById(int id) {
        try {
            return Block.func_196257_b((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static BlockState getDefaultBlockStateForStateId(int id) {
        try {
            return Block.func_196257_b((int)id).func_177230_c().func_176223_P();
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.field_71417_B.func_198024_e();
        }
        return mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198105_m();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.field_71417_B.func_198026_f();
        }
        return mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198091_l() / (double)mc.func_228018_at_().func_198083_n();
    }

    public static void minecraftOrtho(Minecraft mc, boolean raw) {
        MainWindow mainwindow = mc.func_228018_at_();
        int width = raw ? mc.func_228018_at_().func_198105_m() : mainwindow.func_198109_k();
        int height = raw ? mc.func_228018_at_().func_198083_n() : mainwindow.func_198091_l();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)width / mainwindow.func_198100_s()), (double)((double)height / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static void clearHeightsData586(long[] data) {
        System.arraycopy(ZERO_LONG_586, 0, data, 0, 586);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static void setShaderProgram(int program) {
        if (shadersType == -500) {
            shadersType = GL.getCapabilities().OpenGL20 ? 0 : (GL.getCapabilities().GL_ARB_shader_objects ? 1 : (GL.getCapabilities().GL_EXT_separate_shader_objects ? 2 : -1));
            EXTgeometryShader = GL.getCapabilities().GL_EXT_geometry_shader4 || GL.getCapabilities().GL_ARB_geometry_shader4;
        }
        switch (shadersType) {
            case 0: {
                GlStateManager.func_227723_g_((int)program);
                break;
            }
            case 1: {
                ARBShaderObjects.glUseProgramObjectARB((int)program);
                break;
            }
            case 2: {
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35633, (int)program);
                if (EXTgeometryShader) {
                    EXTSeparateShaderObjects.glUseShaderProgramEXT((int)36313, (int)program);
                }
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35632, (int)program);
                EXTSeparateShaderObjects.glActiveProgramEXT((int)program);
                break;
            }
        }
    }

    public static Path convertToOutdated(Path path, int attempts) throws IOException {
        if (path.getFileName().toString().endsWith(OUTDATED_FILE_EXT)) {
            return path;
        }
        Path outdatedPath = path.resolveSibling(path.getFileName().toString() + OUTDATED_FILE_EXT);
        if (Files.exists(path, new LinkOption[0])) {
            Misc.convertToOutdated(path, outdatedPath, attempts);
        }
        return outdatedPath;
    }

    private static void convertToOutdated(Path path, Path outdatedPath, int attempts) throws IOException {
        --attempts;
        try {
            Files.move(path, outdatedPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to convert file to outdated! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.convertToOutdated(path, outdatedPath, attempts);
            }
            throw e;
        }
    }

    public static void drawNormalText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_243247_a(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static boolean hasItem(PlayerEntity player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static int getTeamColour(Entity e) {
        Integer teamColour = null;
        Team team = e.func_96124_cp();
        if (team != null) {
            teamColour = team.func_178775_l().func_211163_e();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public static boolean hasEffect(PlayerEntity player, Effect effect) {
        return effect != null && player != null && player.func_70644_a(effect);
    }

    public static boolean hasEffect(Effect effect) {
        return Misc.hasEffect((PlayerEntity)Minecraft.func_71410_x().field_71439_g, effect);
    }

    static {
        shadersType = -500;
    }
}

