/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.gui.ScreenBase;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private TextFieldWidget commandFormatTextField;
    private TextFieldWidget dimensionCommandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private String dimensionCommandFormat;
    private ITextComponent waypointCommandHint = new TranslationTextComponent("gui.xaero_wm_teleport_command_waypoints_hint");

    public GuiMapTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_teleport_command"));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultMapTeleport();
        this.commandFormat = mapWorld.getTeleportCommandFormat();
        this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        String defaultMapTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT);
        String defaultMapTeleportDimensionFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT);
        this.commandFormatTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7 + 60, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_teleport_command"));
        this.commandFormatTextField.func_146203_f(500);
        this.commandFormatTextField.func_146180_a(this.usingDefault ? defaultMapTeleportFormat : this.commandFormat);
        this.dimensionCommandFormatTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7 + 90, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_dimension_teleport_command"));
        this.dimensionCommandFormatTextField.func_146203_f(500);
        this.dimensionCommandFormatTextField.func_146180_a(this.usingDefault ? defaultMapTeleportDimensionFormat : this.dimensionCommandFormat);
        if (this.usingDefault) {
            this.dimensionCommandFormatTextField.field_230693_o_ = false;
            this.commandFormatTextField.field_230693_o_ = false;
            this.commandFormatTextField.func_146184_c(false);
            this.dimensionCommandFormatTextField.func_146184_c(false);
            this.commandFormatTextField.func_146193_g(-11184811);
            this.dimensionCommandFormatTextField.func_146193_g(-11184811);
        } else {
            this.commandFormatTextField.func_212954_a(text -> {
                this.commandFormat = text;
            });
            this.dimensionCommandFormatTextField.func_212954_a(text -> {
                this.dimensionCommandFormat = text;
            });
        }
        this.func_230481_d_((IGuiEventListener)this.commandFormatTextField);
        this.func_230481_d_((IGuiEventListener)this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.func_230480_a_((Widget)new MySmallButton(0, this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 7 + 138, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_teleport_command_waypoints"), b -> SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen((Screen)this, this.escape)));
        }
        this.confirmButton = new MySmallButton(1, this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> {
            if (this.canConfirm()) {
                if (!this.usingDefault && this.commandFormat.equals(defaultMapTeleportFormat) && this.dimensionCommandFormat.equals(defaultMapTeleportDimensionFormat)) {
                    this.usingDefault = true;
                }
                mapWorld.setTeleportCommandFormat(this.commandFormat);
                mapWorld.setDimensionTeleportCommandFormat(this.dimensionCommandFormat);
                mapWorld.setUseDefaultMapTeleport(this.usingDefault);
                mapWorld.saveConfig();
                this.goBack();
            }
        });
        this.func_230480_a_((Widget)this.confirmButton);
        this.func_230480_a_((Widget)new MySmallButton(2, this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel"), b -> this.goBack()));
        this.func_230480_a_((Widget)new MySmallButton(202, this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 7 + 20, ConfigUtils.optionNameValue((ITextComponent)new TranslationTextComponent("gui.xaero_wm_use_default"), (ITextComponent)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault)), b -> {
            this.usingDefault = !this.usingDefault;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }));
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(matrixStack, mouseX, mouseY, partial);
        this.func_230446_a_(matrixStack);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        if (SupportMods.minimap()) {
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.waypointCommandHint, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 124), (int)-5592406);
        }
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"{x} {y} {z} {d}", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 46), (int)-5592406);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partial);
        this.commandFormatTextField.func_230430_a_(matrixStack, mouseX, mouseY, partial);
        this.dimensionCommandFormatTextField.func_230430_a_(matrixStack, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.commandFormatTextField.func_146178_a();
        this.dimensionCommandFormatTextField.func_146178_a();
        this.confirmButton.field_230693_o_ = this.canConfirm();
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.func_230982_a_(0.0, 0.0);
        }
        return super.func_231046_a_(par1, par2, par3);
    }

    public void func_231035_a_(IGuiEventListener l) {
        IGuiEventListener currentFocused = this.func_241217_q_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).func_146195_b(false);
        }
        super.func_231035_a_(l);
    }
}

