/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.server.player.ServerPlayerData;

public class HandshakePacket {
    public static final int NETWORK_COMPATIBILITY = 3;
    private final int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(3);
    }

    public void write(PacketBuffer u) {
        u.writeInt(this.networkVersion);
    }

    public static HandshakePacket read(PacketBuffer buffer) {
        return new HandshakePacket(buffer.readInt());
    }

    public static class ServerHandler
    implements BiConsumer<HandshakePacket, ServerPlayerEntity> {
        @Override
        public void accept(HandshakePacket message, ServerPlayerEntity player) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements Consumer<HandshakePacket> {
        @Override
        public void accept(HandshakePacket message) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMapProcessor().setServerModNetworkVersion(message.networkVersion);
            WorldMap.messageHandler.sendToServer((Object)new HandshakePacket());
        }
    }
}

