/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mixin;

import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.WorldMapSession;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.XaeroWorldMapCore;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPlayNetworkHandler
implements IWorldMapClientPlayNetHandler {
    WorldMapSession xaero_worldmapSession;

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleChunkBlocksUpdate"})
    public void onOnChunkDeltaUpdate(ClientboundSectionBlocksUpdatePacket packet, CallbackInfo info) {
        XaeroWorldMapCore.onMultiBlockChange(packet);
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLevelChunk"})
    public void onOnChunkData(int x, int z, ClientboundLevelChunkPacketData packet, CallbackInfo info) {
        XaeroWorldMapCore.onChunkData(x, z, packet);
    }

    @Inject(at={@At(value="HEAD")}, method={"queueLightUpdate"})
    public void onChunkLightData(int x, int z, ClientboundLightUpdatePacketData packet, CallbackInfo info) {
        XaeroWorldMapCore.onChunkLightData(x, z, packet);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleBlockUpdate"})
    public void onOnBlockUpdate(ClientboundBlockUpdatePacket packet, CallbackInfo info) {
        XaeroWorldMapCore.onBlockChange(packet);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleSetSpawn"})
    public void onOnPlayerSpawnPosition(ClientboundSetDefaultSpawnPositionPacket packet, CallbackInfo info) {
        XaeroWorldMapCore.handlePlayerSetSpawnPacket(packet);
    }

    @Override
    public WorldMapSession getXaero_worldmapSession() {
        return this.xaero_worldmapSession;
    }

    @Override
    public void setXaero_worldmapSession(WorldMapSession session) {
        this.xaero_worldmapSession = session;
    }

    @Inject(at={@At(value="HEAD")}, method={"cleanup"})
    public void onCleanup(CallbackInfo info) {
        XaeroWorldMapCore.onPlayNetHandlerCleanup((ClientPacketListener)this);
    }
}

