/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.lib.common.util.ImageIOUtils;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.gui.GuiMap;
import xaero.map.misc.CachedFunction;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.MapUpdateFastConfig;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public abstract class MapWriter {
    public static final int NO_Y_VALUE = Short.MAX_VALUE;
    public static final int MAX_TRANSPARENCY_BLEND_DEPTH = 5;
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private int caveStart;
    private int writingLayer = Integer.MAX_VALUE;
    private int writtenCaveStart = Integer.MAX_VALUE;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final BlockPos.MutableBlockPos mutableLocalPos;
    private final BlockPos.MutableBlockPos mutableGlobalPos;
    protected final RandomSource usedRandom = RandomSource.m_216335_((long)0L);
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private MapProcessor mapProcessor;
    private ArrayList<BlockState> buggedStates;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private int topH;
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private int firstTransparentStateY;
    private final BlockPos.MutableBlockPos mutableBlockPos3;
    private CachedFunction<FluidState, BlockState> fluidToBlock;
    private BiomeGetter biomeGetter;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private MapTileChunk rightChunk = null;
    private MapTileChunk bottomRightChunk = null;
    private HashMap<String, Integer> textureColours;
    private HashMap<BlockState, Integer> blockColours;
    private final Object2IntMap<BlockState> blockTintIndices;
    private long lastLayerSwitch;
    private BlockState lastBlockStateForTextureColor = null;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.MutableBlockPos();
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
        this.buggedStates = new ArrayList();
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> this.shouldOverlay((StateHolder<?, ?>)state));
        this.mutableBlockPos3 = new BlockPos.MutableBlockPos();
        this.fluidToBlock = new CachedFunction<FluidState, BlockState>(FluidState::m_76188_);
        this.biomeGetter = biomeGetter;
        this.blockTintIndices = new Object2IntOpenHashMap();
    }

    protected abstract boolean blockStateHasTranslucentRenderType(BlockState var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block36: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block36;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
                        boolean loadChunksConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.LOAD_NEW_CHUNKS);
                        boolean updateChunksConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.UPDATE_CHUNKS);
                        if (this.mapProcessor.getWorld() == null || this.mapProcessor.isCurrentMapLocked() || this.mapProcessor.getMapWorld().isCacheOnlyMode()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((Level)this.mapProcessor.getWorld()) && (updateChunksConfig || loadChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave())) {
                            Object blockTintProvider;
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                if (this.mapProcessor.getWorld().m_46472_() != this.mapProcessor.getMapWorld().getCurrentDimensionId()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    Registry<Biome> biomeRegistry = this.mapProcessor.worldBiomeRegistry;
                                    boolean loadChunks = loadChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave();
                                    boolean updateChunks = updateChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave();
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS);
                                    boolean detailedDebug = WorldMap.detailed_debug;
                                    int caveDepth = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH);
                                    BlockPos.MutableBlockPos mutableBlockPos3 = this.mutableBlockPos3;
                                    blockTintProvider = this.mapProcessor.getWorldBlockTintProvider();
                                    MapUpdateFastConfig config = new MapUpdateFastConfig();
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        if (this.writeMap((Level)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, (BlockTintProvider)blockTintProvider, caveDepth, config)) {
                                            --i;
                                        }
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                            int startRegionX = this.startTileChunkX >> 3;
                            int startRegionZ = this.startTileChunkZ >> 3;
                            int endRegionX = this.endTileChunkX >> 3;
                            int endRegionZ = this.endTileChunkZ >> 3;
                            boolean shouldRequestLoading = false;
                            LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                            shouldRequestLoading = nextToLoad != null ? nextToLoad.shouldAllowAnotherRegionToLoad() : true;
                            this.regionBuffer.clear();
                            int comparisonChunkX = this.playerChunkX - 16;
                            int comparisonChunkZ = this.playerChunkZ - 16;
                            LeveledRegion.setComparison(comparisonChunkX, comparisonChunkZ, 0, comparisonChunkX, comparisonChunkZ);
                            for (int visitRegionX = startRegionX; visitRegionX <= endRegionX; ++visitRegionX) {
                                for (int visitRegionZ = startRegionZ; visitRegionZ <= endRegionZ; ++visitRegionZ) {
                                    MapRegion visitRegion = this.mapProcessor.getLeafMapRegion(this.writingLayer, visitRegionX, visitRegionZ, true);
                                    if (visitRegion != null && visitRegion.getLoadState() == 2) {
                                        visitRegion.registerVisit();
                                    }
                                    blockTintProvider = visitRegion;
                                    synchronized (blockTintProvider) {
                                        if (visitRegion.isResting() && shouldRequestLoading && visitRegion.canRequestReload_unsynced() && visitRegion.getLoadState() != 2) {
                                            visitRegion.calculateSortingChunkDistance();
                                            Misc.addToListOfSmallest(10, this.regionBuffer, visitRegion);
                                        }
                                        continue;
                                    }
                                }
                            }
                            int toRequest = 1;
                            int counter = 0;
                            for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                MapRegion mapRegion = region;
                                synchronized (mapRegion) {
                                    if (!region.canRequestReload_unsynced() || region.getLoadState() == 2) {
                                        continue;
                                    }
                                    region.setBeingWritten(true);
                                    this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion<?>)region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    private int getWriteDistance() {
        int limit;
        int n = limit = this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave() ? Integer.MAX_VALUE : (Integer)WorldMap.INSTANCE.getConfigs().getClientConfigManager().getEffective((ConfigOption)WorldMapProfiledConfigOptions.WRITING_DISTANCE);
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        return Math.min(limit, Math.min(32, (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMap(Level world, double playerX, double playerY, double playerZ, Registry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, MapUpdateFastConfig config) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        Level level = world;
        synchronized (level) {
            if (this.insideX == 0 && this.insideZ == 0) {
                if (this.X == 0 && this.Z == 0) {
                    this.writtenCaveStart = this.caveStart;
                }
                this.mapProcessor.updateCaveStart();
                int newWritingLayer = this.mapProcessor.getCurrentCaveLayer();
                if (this.writingLayer != newWritingLayer && System.currentTimeMillis() - this.lastLayerSwitch > 300L) {
                    this.writingLayer = newWritingLayer;
                    this.lastLayerSwitch = System.currentTimeMillis();
                }
                this.loadDistance = this.getWriteDistance();
                if (this.writingLayer != Integer.MAX_VALUE && !(Minecraft.m_91087_().f_91080_ instanceof GuiMap)) {
                    this.loadDistance = Math.min(16, this.loadDistance);
                }
                this.caveStart = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(this.writingLayer).getCaveStart();
                if (this.caveStart != this.writtenCaveStart) {
                    this.loadDistance = Math.min(4, this.loadDistance);
                }
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl25 : MonitorExitStatement: MONITOREXIT : var21_18
            int tileChunkX = this.startTileChunkX + this.X;
            int tileChunkZ = this.startTileChunkZ + this.Z;
            int tileChunkLocalX = tileChunkX & 7;
            int tileChunkLocalZ = tileChunkZ & 7;
            int chunkX = tileChunkX * 4 + this.insideX;
            int chunkZ = tileChunkZ * 4 + this.insideZ;
            boolean wasSkipped = this.writeChunk(world, this.loadDistance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, this.caveStart, this.writingLayer, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ, config);
            return wasSkipped && (Math.abs(chunkX - this.playerChunkX) > 8 || Math.abs(chunkZ - this.playerChunkZ) > 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeChunk(Level world, int distance, boolean onlyLoad, Registry<Biome> biomeRegistry, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ, MapUpdateFastConfig updateConfig) {
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapTileChunk tileChunk = null;
        this.rightChunk = null;
        MapTileChunk bottomChunk = null;
        this.bottomRightChunk = null;
        int worldBottomY = world.m_141937_();
        int worldTopY = world.m_151558_();
        MapRegion region = this.mapProcessor.getLeafMapRegion(layerToWrite, regionX, regionZ, true);
        boolean wasSkipped = true;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                boolean isProperLoadState;
                boolean createdTileChunk = false;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = isProperLoadState = region.getLoadState() == 2;
                    if (isProperLoadState) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (isProperLoadState && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                            region.setAllCachePrepared(false);
                            createdTileChunk = true;
                        }
                        if (!region.isNormalMapData()) {
                            region.getDim().getLayeredMapRegions().applyToEachLoadedLayer((i, layer) -> {
                                if (i.intValue() != region.getCaveLayer()) {
                                    MapRegion sameRegionAnotherLayer = this.mapProcessor.getLeafMapRegion((int)i, regionX, regionZ, true);
                                    sameRegionAnotherLayer.setOutdatedWithOtherLayers(true);
                                    sameRegionAnotherLayer.setHasHadTerrain();
                                }
                            });
                        }
                    }
                }
                if (regionIsResting && isProperLoadState) {
                    if (tileChunk != null && tileChunk.getLoadState() == 2) {
                        if (!tileChunk.getLeafTexture().shouldUpload()) {
                            boolean cave = caveStart != Integer.MAX_VALUE;
                            boolean fullCave = caveStart == Integer.MIN_VALUE;
                            int lowH = worldBottomY;
                            if (cave && !fullCave && (lowH = caveStart + 1 - caveDepth) < worldBottomY) {
                                lowH = worldBottomY;
                            }
                            if (chunkX >= this.playerChunkX - distance && chunkX <= this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ <= this.playerChunkZ + distance) {
                                LevelChunk chunk = (LevelChunk)world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
                                MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                                boolean chunkUpdated = false;
                                try {
                                    chunkUpdated = chunk != null && (mapTile == null || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                                }
                                catch (IllegalAccessException | IllegalArgumentException e) {
                                    throw new RuntimeException(e);
                                }
                                if (chunkUpdated && !(chunk instanceof EmptyLevelChunk)) {
                                    boolean edgeChunk = false;
                                    block8: for (int i2 = -1; i2 < 2; ++i2) {
                                        for (int j = -1; j < 2; ++j) {
                                            LevelChunk neighbor;
                                            if (i2 == 0 && j == 0 || (neighbor = world.m_6325_(chunkX + i2, chunkZ + j)) != null && !(neighbor instanceof EmptyLevelChunk)) continue;
                                            edgeChunk = true;
                                            break block8;
                                        }
                                    }
                                    if (!edgeChunk && (mapTile == null && loadChunks || mapTile != null && updateChunks && (!onlyLoad || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth))) {
                                        wasSkipped = false;
                                        if (mapTile == null) {
                                            mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                            tileChunk.setChanged(true);
                                        }
                                        MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                        int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                        Heightmap.Types typeWorldSurface = Heightmap.Types.WORLD_SURFACE;
                                        MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                        MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                        boolean triedFetchingBottomChunk = false;
                                        boolean triedFetchingRightChunk = false;
                                        for (int x = 0; x < 16; ++x) {
                                            for (int z = 0; z < 16; ++z) {
                                                boolean xEdge;
                                                int mappedHeight = chunk.m_5885_(typeWorldSurface, x, z);
                                                int startHeight = cave && !fullCave ? caveStart : (ignoreHeightmaps || mappedHeight < worldBottomY ? sectionBasedHeight : mappedHeight);
                                                if (startHeight >= worldTopY) {
                                                    startHeight = worldTopY - 1;
                                                }
                                                MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                                this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, lowH, cave, fullCave, mappedHeight, mapTile.wasWrittenOnce(), ignoreHeightmaps, biomeRegistry, flowers, worldBottomY, mutableBlockPos3);
                                                this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig), true, this.blockStateShortShapeCache, updateConfig);
                                                boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                                boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                                if (fullyEqual) continue;
                                                MapBlock loadedBlock = this.loadingObject;
                                                mapTile.setBlock(x, z, loadedBlock);
                                                this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                                if (equalsSlopesExcluded) continue;
                                                tileChunk.setChanged(true);
                                                boolean zEdge = z == 15;
                                                boolean bl = xEdge = x == 15;
                                                if (!zEdge && !xEdge || currentPixel != null && currentPixel.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig) == loadedBlock.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig)) continue;
                                                if (zEdge) {
                                                    if (!triedFetchingBottomChunk && bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                        bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                                                        triedFetchingBottomChunk = true;
                                                        MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                        if (bottomTile != null) {
                                                            bottomChunk.setChanged(true);
                                                        }
                                                    }
                                                    if (bottomTile != null && bottomTile.isLoaded()) {
                                                        bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                        if (!xEdge) {
                                                            bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                        }
                                                    }
                                                    if (!xEdge) continue;
                                                    this.updateBottomRightTile(region, tileChunk, bottomChunk, tileChunkLocalX, tileChunkLocalZ);
                                                    continue;
                                                }
                                                if (!xEdge) continue;
                                                if (!triedFetchingRightChunk && rightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                    this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                    triedFetchingRightChunk = true;
                                                    MapTile mapTile3 = rightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ) : null;
                                                    if (rightTile != null) {
                                                        this.rightChunk.setChanged(true);
                                                    }
                                                }
                                                if (rightTile == null || !rightTile.isLoaded()) continue;
                                                rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                            }
                                        }
                                        mapTile.setWorldInterpretationVersion(1);
                                        if (mapTile.getWrittenCaveStart() != caveStart) {
                                            tileChunk.setChanged(true);
                                        }
                                        mapTile.setWrittenCave(caveStart, caveDepth);
                                        tileChunk.setTile(this.insideX, this.insideZ, mapTile, this.blockStateShortShapeCache);
                                        mapTile.setWrittenOnce(true);
                                        mapTile.setLoaded(true);
                                        ReflectionUtils.setReflectFieldValue((Object)chunk, (Field)XaeroWorldMapCore.chunkCleanField, (Object)true);
                                    }
                                }
                            }
                        }
                        if (createdTileChunk) {
                            if (tileChunk.includeInSave()) {
                                tileChunk.setHasHadTerrain();
                            }
                            this.mapProcessor.getMapRegionHighlightsPreparer().prepare(region, tileChunkLocalX, tileChunkLocalZ, false);
                            if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                                region.setChunk(tileChunkLocalX, tileChunkLocalZ, null);
                                tileChunk = null;
                            }
                        }
                    }
                    if (tileChunk != null && this.insideX == 3 && this.insideZ == 3 && tileChunk.wasChanged()) {
                        tileChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache, updateConfig);
                        if (bottomChunk == null && tileChunkLocalZ < 7) {
                            bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                        }
                        if (this.rightChunk == null && tileChunkLocalX < 7) {
                            this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                        }
                        if (this.bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                            this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                        }
                        if (bottomChunk != null && bottomChunk.wasChanged()) {
                            bottomChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache, updateConfig);
                            bottomChunk.setChanged(false);
                        }
                        if (this.rightChunk != null && this.rightChunk.wasChanged()) {
                            this.rightChunk.setToUpdateBuffers(true);
                            this.rightChunk.setChanged(false);
                        }
                        if (this.bottomRightChunk != null && this.bottomRightChunk.wasChanged()) {
                            this.bottomRightChunk.setToUpdateBuffers(true);
                            this.bottomRightChunk.setChanged(false);
                        }
                        tileChunk.setChanged(false);
                    }
                }
            } else {
                this.insideX = 3;
                this.insideZ = 3;
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
        return wasSkipped;
    }

    public void updateBottomRightTile(MapRegion region, MapTileChunk tileChunk, MapTileChunk bottomChunk, int tileChunkLocalX, int tileChunkLocalZ) {
        MapTile bottomRightTile;
        MapTile mapTile = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
        if (bottomRightTile == null) {
            if (this.insideX == 3 && tileChunkLocalX < 7) {
                if (this.insideZ == 3) {
                    if (tileChunkLocalZ < 7) {
                        this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                    }
                    MapTile mapTile2 = bottomRightTile = this.bottomRightChunk != null ? this.bottomRightChunk.getTile(0, 0) : null;
                    if (bottomRightTile != null) {
                        this.bottomRightChunk.setChanged(true);
                    }
                } else {
                    if (this.rightChunk == null) {
                        this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                    }
                    MapTile mapTile3 = bottomRightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ + 1) : null;
                    if (bottomRightTile != null) {
                        this.rightChunk.setChanged(true);
                    }
                }
            } else if (this.insideX != 3 && this.insideZ == 3 && tileChunkLocalZ < 7) {
                MapTile mapTile4 = bottomRightTile = bottomChunk != null ? bottomChunk.getTile(this.insideX + 1, 0) : null;
                if (bottomRightTile != null) {
                    bottomChunk.setChanged(true);
                }
            }
        }
        if (bottomRightTile != null && bottomRightTile.isLoaded()) {
            bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
        }
    }

    public int getSectionBasedHeight(LevelChunk bchunk, int startY) {
        LevelChunkSection searchedSection;
        int i;
        LevelChunkSection[] sections = bchunk.m_7103_();
        if (sections.length == 0) {
            return 0;
        }
        int chunkBottomY = bchunk.m_141937_();
        int playerSection = Math.min(startY - chunkBottomY >> 4, sections.length - 1);
        if (playerSection < 0) {
            playerSection = 0;
        }
        int result = 0;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection.m_188008_()) continue;
            result = chunkBottomY + (i << 4) + 15;
        }
        if (playerSection > 0 && result == 0) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection.m_188008_()) continue;
                result = chunkBottomY + (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(BlockState state) {
        return (double)state.m_60791_() >= 0.5;
    }

    private boolean shouldOverlayCached(StateHolder<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    public boolean shouldOverlay(StateHolder<?, ?> state) {
        if (state instanceof BlockState) {
            BlockState blockState = (BlockState)state;
            if (blockState.m_60734_() instanceof AirBlock || blockState.m_60734_() instanceof GlassBlock) {
                return true;
            }
            return this.blockStateHasTranslucentRenderType(blockState);
        }
        FluidState fluidState = (FluidState)state;
        return ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == RenderType.m_110466_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(BlockState state, Block b, boolean flowers) {
        boolean isFlower;
        if (!(b instanceof LiquidBlock) && state.m_60799_() == RenderShape.INVISIBLE) {
            return true;
        }
        if (b == Blocks.f_50081_) {
            return true;
        }
        if (b == Blocks.f_50034_) {
            return true;
        }
        if (b == Blocks.f_50058_ || b == Blocks.f_50185_) {
            return true;
        }
        boolean bl = isFlower = b instanceof TallFlowerBlock || b instanceof FlowerBlock || state.m_204336_(BlockTags.f_13041_);
        if (b instanceof DoublePlantBlock && !isFlower) {
            return true;
        }
        if (isFlower && !flowers) {
            return true;
        }
        ArrayList<BlockState> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVanillaColor(BlockState state, Level world, BlockPos pos) {
        MaterialColor materialColor = null;
        try {
            materialColor = state.m_60780_((BlockGetter)world, pos);
        }
        catch (Throwable t) {
            ArrayList<BlockState> arrayList = this.buggedStates;
            synchronized (arrayList) {
                this.buggedStates.add(state);
            }
            WorldMap.LOGGER.info("Broken vanilla map color definition found: " + Registry.f_122824_.m_7981_((Object)state.m_60734_()));
        }
        return materialColor != null && materialColor.f_76396_ != 0;
    }

    private BlockState unpackFramedBlocks(BlockState original, Level world, BlockPos globalPos) {
        BlockEntity tileEntity;
        if (original.m_60734_() instanceof AirBlock) {
            return original;
        }
        BlockState result = original;
        if (SupportMods.framedBlocks() && SupportMods.supportFramedBlocks.isFrameBlock(world, null, original) && (tileEntity = world.m_7702_(globalPos)) != null && ((result = SupportMods.supportFramedBlocks.unpackFramedBlock(world, null, original, tileEntity)) == null || result.m_60734_() instanceof AirBlock)) {
            result = original;
        }
        return result;
    }

    public void loadPixel(Level world, MapBlock pixel, MapBlock currentPixel, LevelChunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, BlockPos.MutableBlockPos mutableBlockPos3) {
        pixel.prepareForWriting(worldBottomY);
        this.overlayBuilder.startBuilding();
        boolean underair = !cave || fullCave;
        boolean shouldEnterGround = fullCave;
        BlockState opaqueState = null;
        byte workingLight = -1;
        boolean worldHasSkyLight = world.m_6042_().f_223549_();
        byte workingSkyLight = worldHasSkyLight ? (byte)15 : 0;
        this.topH = lowY;
        this.mutableGlobalPos.m_122178_((bchunk.m_7697_().f_45578_ << 4) + insideX, lowY - 1, (bchunk.m_7697_().f_45579_ << 4) + insideZ);
        boolean shouldExtendTillTheBottom = false;
        int transparentSkipY = 0;
        int h = highY;
        while (h >= lowY) {
            Block b;
            this.mutableLocalPos.m_122178_(insideX, h, insideZ);
            BlockState state = bchunk.m_8055_((BlockPos)this.mutableLocalPos);
            if (state == null) {
                state = Blocks.f_50016_.m_49966_();
            }
            this.mutableGlobalPos.m_142448_(h);
            state = this.unpackFramedBlocks(state, world, (BlockPos)this.mutableGlobalPos);
            FluidState fluidFluidState = state.m_60819_();
            boolean bl = shouldExtendTillTheBottom = !shouldExtendTillTheBottom && !this.overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5;
            if (shouldExtendTillTheBottom) {
                for (transparentSkipY = h - 1; transparentSkipY >= lowY; --transparentSkipY) {
                    FluidState traceFluidState;
                    BlockState traceState = bchunk.m_8055_((BlockPos)mutableBlockPos3.m_122178_(insideX, transparentSkipY, insideZ));
                    if (traceState == null) {
                        traceState = Blocks.f_50016_.m_49966_();
                    }
                    if (!(traceFluidState = traceState.m_60819_()).m_76178_()) {
                        if (!this.shouldOverlayCached((StateHolder<?, ?>)traceFluidState)) break;
                        if (!(traceState.m_60734_() instanceof AirBlock) && traceState.m_60734_() == this.fluidToBlock.apply(traceFluidState).m_60734_()) continue;
                    }
                    if (!this.shouldOverlayCached((StateHolder<?, ?>)traceState)) break;
                }
            }
            this.mutableGlobalPos.m_142448_(h + 1);
            workingLight = (byte)world.m_45517_(LightLayer.BLOCK, (BlockPos)this.mutableGlobalPos);
            if (cave && workingLight < 15 && worldHasSkyLight) {
                workingSkyLight = !ignoreHeightmaps && !fullCave && highY >= mappedHeight ? (byte)15 : (byte)((byte)world.m_45517_(LightLayer.SKY, (BlockPos)this.mutableGlobalPos));
            }
            this.mutableGlobalPos.m_142448_(h);
            if (!(fluidFluidState.m_76178_() || cave && shouldEnterGround)) {
                underair = true;
                BlockState fluidState = this.fluidToBlock.apply(fluidFluidState);
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, workingLight, workingSkyLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, fluidFluidState, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers, underair)) {
                    opaqueState = state;
                    break;
                }
            }
            if ((b = state.m_60734_()) instanceof AirBlock) {
                underair = true;
            } else if (underair && state.m_60734_() != this.fluidToBlock.apply(fluidFluidState).m_60734_()) {
                if (cave && shouldEnterGround) {
                    if (!(state.m_60767_().m_76335_() || state.m_60767_().m_76336_() || state.m_60811_() == PushReaction.DESTROY || this.shouldOverlayCached((StateHolder<?, ?>)state))) {
                        underair = false;
                        shouldEnterGround = false;
                    }
                } else if (this.loadPixelHelp(pixel, currentPixel, world, state, workingLight, workingSkyLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, null, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers, underair)) {
                    opaqueState = state;
                    break;
                }
            }
            h = shouldExtendTillTheBottom ? transparentSkipY : h - 1;
        }
        if (h < lowY) {
            h = lowY;
        }
        ResourceKey<Biome> blockBiome = null;
        BlockState state = opaqueState == null ? Blocks.f_50016_.m_49966_() : opaqueState;
        this.overlayBuilder.finishBuilding(pixel);
        byte light = 0;
        if (opaqueState != null) {
            light = workingLight;
            if (cave && light < 15 && pixel.getNumberOfOverlays() == 0 && workingSkyLight > light) {
                light = workingSkyLight;
            }
        } else {
            h = worldBottomY;
        }
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state || currentPixel.getTopHeight() != this.topH) {
            this.mutableGlobalPos.m_142448_(this.topH);
            blockBiome = this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry);
            this.mutableGlobalPos.m_142448_(h);
        } else {
            blockBiome = currentPixel.getBiome();
        }
        if (this.overlayBuilder.getOverlayBiome() != null) {
            blockBiome = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.topH, blockBiome, light, glowing, cave);
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, Level world, BlockState state, byte light, byte skyLight, LevelChunk bchunk, int insideX, int insideZ, int h, boolean canReuseBiomeColours, boolean cave, FluidState fluidFluidState, Registry<Biome> biomeRegistry, int transparentSkipY, boolean shouldExtendTillTheBottom, boolean flowers, boolean underair) {
        Block b = state.m_60734_();
        if (this.isInvisible(state, b, flowers)) {
            return false;
        }
        if (this.shouldOverlayCached((StateHolder<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (cave && !underair) {
                return false;
            }
            if (h > this.topH) {
                this.topH = h;
            }
            byte overlayLight = light;
            if (this.overlayBuilder.isEmpty()) {
                this.firstTransparentStateY = h;
                if (cave && skyLight > overlayLight) {
                    overlayLight = skyLight;
                }
            }
            if (shouldExtendTillTheBottom) {
                this.overlayBuilder.getCurrentOverlay().increaseOpacity(this.overlayBuilder.getCurrentOverlay().getState().m_60739_((BlockGetter)world, (BlockPos)this.mutableGlobalPos) * (h - transparentSkipY));
            } else {
                ResourceKey<Biome> overlayBiome = this.overlayBuilder.getOverlayBiome();
                if (overlayBiome == null) {
                    overlayBiome = canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state ? currentPixel.getBiome() : this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry);
                }
                this.overlayBuilder.build(state, state.m_60739_((BlockGetter)world, (BlockPos)this.mutableGlobalPos), overlayLight, this.mapProcessor, overlayBiome);
            }
            return false;
        }
        if (!this.hasVanillaColor(state, world, (BlockPos)this.mutableGlobalPos)) {
            return false;
        }
        if (cave && !underair) {
            return true;
        }
        if (h > this.topH) {
            this.topH = h;
        }
        return true;
    }

    protected abstract List<BakedQuad> getQuads(BakedModel var1, BlockState var2, Direction var3);

    protected abstract TextureAtlasSprite getParticleIcon(BlockModelShaper var1, BakedModel var2, BlockState var3);

    public int loadBlockColourFromTexture(BlockState state, boolean convert, Level world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.blockTintIndices.clear();
            this.lastBlockStateForTextureColor = null;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMapClientConfigUtils.getDebug()) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        if (state == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        Block b = state.m_60734_();
        if (c == null) {
            String name = null;
            int tintIndex = -1;
            try {
                Integer cachedColour;
                TextureAtlasSprite texture;
                List<BakedQuad> upQuads = null;
                BlockModelShaper bms = Minecraft.m_91087_().m_91289_().m_110907_();
                BakedModel model = bms.m_110893_(state);
                if (convert) {
                    upQuads = this.getQuads(model, state, Direction.UP);
                }
                TextureAtlasSprite missingTexture = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_((ResourceLocation)null);
                if (upQuads == null || upQuads.isEmpty() || upQuads.get(0).m_173410_() == missingTexture) {
                    texture = this.getParticleIcon(bms, model, state);
                    tintIndex = 0;
                } else {
                    texture = upQuads.get(0).m_173410_();
                    tintIndex = upQuads.get(0).m_111305_();
                }
                if (texture == null) {
                    throw new SilentException("No texture for " + state);
                }
                c = -1;
                name = texture.m_118413_() + ".png";
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    Resource resource = Minecraft.m_91087_().m_91098_().m_213713_(location).orElse(null);
                    if (resource == null) {
                        throw new SilentException("No texture " + location);
                    }
                    InputStream input = resource.m_215507_();
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(input);
                    BufferedImage img = ImageIOUtils.getImageThroughZipError((ImageInputStream)imageInputStream, (String)location.toString());
                    imageInputStream.close();
                    if (img == null) {
                        throw new SilentException("No image loaded " + location);
                    }
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        Raster raster = img.getData();
                        int[] colorHolder = null;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb;
                                if (img.getColorModel().getNumComponents() < 3) {
                                    colorHolder = raster.getPixel(i * diff, j * diff, colorHolder);
                                    int sample = colorHolder[0] & 0xFF;
                                    int a = 255;
                                    if (colorHolder.length > 1) {
                                        a = colorHolder[1];
                                    }
                                    rgb = a << 24 | sample << 16 | sample << 8 | sample;
                                } else {
                                    rgb = img.getRGB(i * diff, j * diff);
                                }
                                int a = rgb >> 24 & 0xFF;
                                if (rgb == 0 || a == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                alpha += a;
                                ++total;
                            }
                        }
                    }
                    if (total == 0) {
                        total = 1;
                    }
                    alpha /= total;
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = alpha << 24 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                WorldMap.LOGGER.info("Block file not found: " + Registry.f_122824_.m_7981_((Object)b));
                c = 0;
                if (state != null && state.m_60780_((BlockGetter)world, globalPos) != null) {
                    c = state.m_60780_((BlockGetter)world, (BlockPos)globalPos).f_76396_;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Exception when loading " + Registry.f_122824_.m_7981_((Object)b) + " texture, using material colour.");
                c = 0;
                if (state.m_60780_((BlockGetter)world, globalPos) != null) {
                    c = state.m_60780_((BlockGetter)world, (BlockPos)globalPos).f_76396_;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                if (e instanceof SilentException) {
                    WorldMap.LOGGER.info(e.getMessage());
                }
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (c != null) {
                this.blockColours.put(state, c);
                this.blockTintIndices.put((Object)state, tintIndex);
            }
        }
        this.lastBlockStateForTextureColor = state;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public void setDirtyInWriteDistance(Player player, Level level) {
        int writeDistance = this.getWriteDistance();
        int playerChunkX = player.m_20183_().m_123341_() >> 4;
        int playerChunkZ = player.m_20183_().m_123343_() >> 4;
        int startChunkX = playerChunkX - writeDistance;
        int startChunkZ = playerChunkZ - writeDistance;
        int endChunkX = playerChunkX + writeDistance;
        int endChunkZ = playerChunkZ + writeDistance;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                LevelChunk chunk = level.m_6325_(x, z);
                if (chunk == null) continue;
                try {
                    XaeroWorldMapCore.chunkCleanField.set(chunk, false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public int getBlockTintIndex(BlockState state) {
        return this.blockTintIndices.getInt((Object)state);
    }
}

