/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO;
    private int glEmptyTexture;
    private PoseStack matrixStack = new PoseStack();
    private Matrix4f projectionMatrix = Matrix4f.m_162203_((float)0.0f, (float)64.0f, (float)0.0f, (float)64.0f, (float)-1.0f, (float)1.0f);

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, RenderTarget defaultFramebuffer, boolean justAllocated) {
        if (this.renderFBO == null) {
            this.renderFBO = new ImprovedFramebuffer(64, 64, false);
            this.glEmptyTexture = this.renderFBO.getFramebufferTexture();
            this.renderFBO.bindAsMainTarget(true);
            GlStateManager.m_84519_();
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.m_84266_((int)16384, (boolean)Minecraft.f_91002_);
            GlStateManager.m_84525_();
        }
        GlStateManager.m_84544_((int)0);
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        PoseStack shaderMatrixStack = RenderSystem.m_157191_();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.m_157182_();
        RenderSystem.m_157425_((Matrix4f)this.projectionMatrix);
        GlStateManager.m_84519_();
        if (justAllocated) {
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.m_84266_((int)16384, (boolean)Minecraft.f_91002_);
        }
        boolean first = true;
        if (srcTextureTopLeft != null) {
            first = this.renderCorner(srcTextureTopLeft, 0, 0, first);
        }
        if (srcTextureTopRight != null) {
            first = this.renderCorner(srcTextureTopRight, 1, 0, first);
        }
        if (srcTextureBottomLeft != null) {
            first = this.renderCorner(srcTextureBottomLeft, 0, 1, first);
        }
        if (srcTextureBottomRight != null) {
            first = this.renderCorner(srcTextureBottomRight, 1, 1, first);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        GlStateManager.m_84525_();
        ProgramManager.m_85578_((int)0);
        GlStateManager.m_84544_((int)0);
        shaderMatrixStack.m_85849_();
        RenderSystem.m_157182_();
        Minecraft mc = Minecraft.m_91087_();
        Misc.minecraftOrtho(mc, false);
        this.renderFBO.m_83970_();
        this.renderFBO.bindDefaultFramebuffer(mc);
        GlStateManager.m_84430_((int)0, (int)0, (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_());
        OpenGLException.checkGLError();
    }

    private boolean renderCorner(Integer srcTexture, int cornerX, int cornerY, boolean first) {
        int texture;
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        int n = texture = srcTexture != -1 ? srcTexture : this.glEmptyTexture;
        if (first) {
            RenderSystem.m_157453_((int)0, (int)texture);
        } else {
            GlStateManager.m_84538_((int)33984);
            GlStateManager.m_84544_((int)texture);
        }
        MapRenderHelper.renderBranchUpdate(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f, first);
        return false;
    }
}

