/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementMenuHitbox;
import xaero.map.element.MapElementMenuScroll;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MenuHitboxReader;
import xaero.map.element.MenuScrollReader;
import xaero.map.element.render.ElementReader;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;

public abstract class MapElementMenuRenderer<E, C> {
    private static final int MENU_RIGHT_PADDING = 27;
    public static final int MAX_MENU_SIZE = 10;
    public static final int MIN_MENU_SIZE = 2;
    protected final MapElementMenuScroll scrollUp = new MapElementMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    protected final MapElementMenuScroll scrollDown = new MapElementMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    protected final MapElementMenuHitbox extraHitbox;
    protected final MenuScrollReader scrollReader = new MenuScrollReader();
    protected final MenuHitboxReader hitboxReader;
    protected final C context;
    protected final MapElementRenderProvider<E, C> provider;
    protected ArrayList<E> filteredElements;
    private EditBox filterField;
    public int menuOffset = 0;
    protected Pattern searchPattern = null;
    protected Pattern searchStartPattern = null;
    protected final Minecraft mc;

    protected MapElementMenuRenderer(C context, MapElementRenderProvider<E, C> provider) {
        this.extraHitbox = new MapElementMenuHitbox(-150, 0, 177, 0);
        this.hitboxReader = new MenuHitboxReader();
        this.mc = Minecraft.m_91087_();
        this.context = context;
        this.provider = provider;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        String searchText = this.filterField == null ? "" : this.filterField.m_94155_();
        this.filterField = new EditBox(mc.f_91062_, screen.f_96543_ - 172, this.menuStartPos(height) + 3 + this.menuSearchPadding(), 150, 20, (Component)Component.m_237115_((String)this.getFilterPlaceholder()));
        this.filterField.m_94144_(searchText);
        this.filterField.m_94151_(s -> this.updateSearch());
        screen.m_7787_(this.filterField);
    }

    public HoveredMapElementHolder<?, ?> renderMenu(GuiGraphics guiGraphics, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc) {
        int menuStartPos;
        if (this.filteredElements == null) {
            this.updateFilteredList();
        }
        ArrayList<E> elements = this.filteredElements;
        int menuElementCount = MapElementMenuRenderer.getMenuElementCount(this.menuStartPos(height));
        if (this.menuOffset + menuElementCount > elements.size()) {
            this.menuOffset = elements.size() - menuElementCount;
        }
        if (this.menuOffset < 0) {
            this.menuOffset = 0;
        }
        int offset = this.menuOffset;
        Object viewed = null;
        int yPos = menuStartPos = this.menuStartPos(height);
        int elementCount = MapElementMenuRenderer.getMenuElementCount(yPos);
        this.beforeMenuRender();
        viewed = this.renderMenuElement(guiGraphics, this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < elements.size(); ++i) {
            viewed = this.renderMenuElement(guiGraphics, elements.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderMenuElement(guiGraphics, this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, offset < elements.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof MapElementMenuScroll) {
            int direction = ((MapElementMenuScroll)viewed).scroll();
            this.menuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderMenuElement(guiGraphics, this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, (Screen)gui, true, mc);
        }
        this.afterMenuRender();
        return oldHovered != null && oldHovered.equals(viewed) ? oldHovered : (viewed == null ? null : MapElementRenderHandler.createResult(viewed, this.getAnyRenderer(viewed)));
    }

    protected abstract void beforeMenuRender();

    protected abstract void afterMenuRender();

    public void postMapRender(GuiGraphics guiGraphics, GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        String searchText = this.filterField.m_94155_();
        boolean searchFieldPlaceHolder = searchText.isEmpty() && !this.filterField.m_93696_();
        boolean invalidRegex = false;
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((EditBox)this.filterField, (String)I18n.m_118938_((String)this.getFilterPlaceholder(), (Object[])new Object[0]), (int)-11184811);
        } else if (!searchText.isEmpty() && this.searchPattern == null) {
            invalidRegex = true;
        }
        this.filterField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
        if (searchFieldPlaceHolder) {
            GuiUtils.setFieldText((EditBox)this.filterField, (String)"");
        } else if (invalidRegex) {
            String errorMessage = I18n.m_118938_((String)"gui.xaero_wm_search_invalid_regex", (Object[])new Object[0]);
            guiGraphics.m_280488_(this.mc.f_91062_, errorMessage, width - 176 - this.mc.f_91062_.m_92895_(errorMessage), this.filterField.m_252907_() + 6, -43691);
        }
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private <O> Object renderMenuElement(GuiGraphics guiGraphics, O element, int width, int yPos, int mouseX, int mouseY, Object viewed, boolean leftMousePressed, Screen gui, boolean enabled, Minecraft mc) {
        boolean hovered;
        MenuScrollReader reader = element == this.scrollDown || element == this.scrollUp ? this.scrollReader : (element == this.extraHitbox ? this.hitboxReader : this.getAnyRenderer(element).getReader());
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && reader.isMouseOverMenuElement(element, xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        if (element != this.extraHitbox) {
            this.renderMenuElement(reader, element, guiGraphics, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        }
        return viewed;
    }

    public <O> void renderMenuElement(ElementReader<O, ?, ?> reader, O element, GuiGraphics guiGraphics, Screen gui, int x, int y, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        if (hovered) {
            matrixStack.m_252880_(pressed ? 1.0f : 2.0f, 0.0f, 0.0f);
        }
        matrixStack.m_252880_((float)x, (float)y, 0.0f);
        matrixStack.m_85841_((float)scale, (float)scale, 1.0f);
        matrixStack.m_252880_(-4.0f, -4.0f, 0.0f);
        String name = reader.getMenuName(element);
        int len = mc.f_91062_.m_92895_(name);
        int textX = -3 - len;
        guiGraphics.m_280509_(textX - 2 - reader.getMenuTextFillLeftPadding(element), -2, textX + len + 2, 11, 0x77000000);
        guiGraphics.m_280488_(mc.f_91062_, name, textX, 0, enabled ? -1 : -11184811);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        matrixStack.m_252880_(4.0f, 4.0f, 0.0f);
        if (element == this.scrollUp || element == this.scrollDown) {
            this.renderScroll((MapElementMenuScroll)element, guiGraphics, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed);
        } else {
            O elementCast = element;
            this.renderInMenu(elementCast, guiGraphics, gui, mouseX, mouseY, scale, enabled, hovered, mc, pressed, textX);
        }
        matrixStack.m_85849_();
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void renderScroll(MapElementMenuScroll scroll, GuiGraphics guiGraphics, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        if (enabled && hovered) {
            matrixStack.m_252880_(pressed ? 1.0f : 2.0f, 0.0f, 0.0f);
        }
        matrixStack.m_252880_(-4.0f, -4.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = enabled ? -1 : -11184811;
        guiGraphics.m_280488_(mc.f_91062_, scroll.getIcon(), 5 - mc.f_91062_.m_92895_(scroll.getIcon()) / 2, 1, color);
        RenderSystem.enableBlend();
    }

    private void updateSearch() {
        String search = this.filterField.m_94155_();
        try {
            this.searchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.searchStartPattern = search.charAt(0) == '^' ? this.searchPattern : Pattern.compile("^" + search.toString().toLowerCase());
            } else {
                this.searchStartPattern = null;
                this.searchPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            this.searchStartPattern = null;
            this.searchPattern = null;
        }
        this.updateFilteredList();
    }

    public boolean charTyped() {
        return this.filterField.m_93696_();
    }

    public boolean keyPressed(GuiMap screen, int keyCode) {
        if (screen.m_7222_() == this.filterField) {
            if (keyCode == 257) {
                this.filterField.m_94144_("");
            }
            return true;
        }
        return false;
    }

    public void mouseScrolled(int direction) {
        this.scroll(direction);
    }

    public void tick() {
        this.filterField.m_94120_();
    }

    public void unfocusAll() {
        if (this.filterField != null) {
            this.filterField.m_93692_(false);
        }
    }

    public void onMenuClosed() {
        this.menuOffset = 0;
        this.searchPattern = null;
        this.searchStartPattern = null;
        this.updateFilteredList();
        this.filterField = null;
    }

    private void scroll(int direction) {
        this.menuOffset += direction;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Pattern getSearchStartPattern() {
        return this.searchStartPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilteredList() {
        MapElementRenderProvider<E, C> provider = this.provider;
        if (provider == null) {
            this.filteredElements = null;
            return;
        }
        if (this.filteredElements == null) {
            this.filteredElements = new ArrayList();
        } else {
            this.filteredElements.clear();
        }
        Pattern regex = this.searchPattern;
        Pattern regexStartsWith = this.searchStartPattern;
        this.beforeFiltering();
        provider.begin(4, this.context);
        try {
            while (provider.hasNext(4, this.context)) {
                E e = provider.getNext(4, this.context);
                if (regex == null) {
                    this.filteredElements.add(e);
                    continue;
                }
                String filterName = this.getRenderer(e).getReader().getFilterName(e).toLowerCase();
                if (regexStartsWith.matcher(filterName).find()) {
                    this.filteredElements.add(0, e);
                    continue;
                }
                if (!regex.matcher(filterName).find()) continue;
                this.filteredElements.add(e);
            }
        }
        finally {
            provider.end(4, this.context);
        }
    }

    protected <O> ElementRenderer<? super O, ?, ?> getAnyRenderer(O element) {
        if (element == this.scrollDown || element == this.scrollUp || element == this.extraHitbox) {
            return null;
        }
        return this.getRenderer(element);
    }

    protected abstract ElementRenderer<? super E, ?, ?> getRenderer(E var1);

    public abstract int menuStartPos(int var1);

    public abstract int menuSearchPadding();

    public abstract void renderInMenu(E var1, GuiGraphics var2, Screen var3, int var4, int var5, double var6, boolean var8, boolean var9, Minecraft var10, boolean var11, int var12);

    protected abstract String getFilterPlaceholder();

    protected abstract void beforeFiltering();
}

