/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;
import xaero.map.element.MapElementGraphics;
import xaero.map.graphics.MapRenderHelper;

public class PlayerTrackerIconRenderer {
    public boolean isPlayerUpsideDown(Player player) {
        Component playerCustomName = player.getCustomName();
        return playerCustomName != null && PlayerTrackerIconRenderer.isUpsideDownName(playerCustomName.getString());
    }

    protected static boolean isUpsideDownName(String playerName) {
        return "Dinnerbone".equals(playerName) || "Grumm".equals(playerName);
    }

    public void renderIcon(MapElementGraphics guiGraphics, Player player, Identifier skinTextureLocation) {
        PoseStack matrixStack = guiGraphics.pose();
        boolean upsideDown = player != null && this.isPlayerUpsideDown(player);
        int textureY = 8 + (upsideDown ? 8 : 0);
        int textureH = 8 * (upsideDown ? -1 : 1);
        AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(skinTextureLocation);
        if (abstractTexture == null) {
            return;
        }
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, XaeroRenderType.POSITION_COLOR_TEX);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.last().pose(), (VertexConsumer)bufferbuilder, -4.0f, -4.0f, 8, textureY, 8, 8, 8, textureH, 1.0f, 1.0f, 1.0f, 1.0f, 64, 64);
        if (player != null && player.isModelPartShown(PlayerModelPart.HAT)) {
            textureY = 8 + (upsideDown ? 8 : 0);
            textureH = 8 * (upsideDown ? -1 : 1);
            MapRenderHelper.blitIntoExistingBuffer(matrixStack.last().pose(), (VertexConsumer)bufferbuilder, -4.0f, -4.0f, 40, textureY, 8, 8, 8, textureH, 1.0f, 1.0f, 1.0f, 1.0f, 64, 64);
        }
        ImmediateRenderUtil.drawImmediateMeshData((MeshData)bufferbuilder.build(), (RenderPipeline)XaeroRenderType.RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL, (RenderSetup.TextureAndSampler)new RenderSetup.TextureAndSampler(abstractTexture.getTextureView(), abstractTexture.getSampler()));
    }

    public void renderIconGUI(GuiGraphics guiGraphics, Player player, Identifier skinTextureLocation) {
        boolean upsideDown = player != null && this.isPlayerUpsideDown(player);
        int textureY = 8 + (upsideDown ? 8 : 0);
        int textureH = 8 * (upsideDown ? -1 : 1);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skinTextureLocation, -4, -4, 8.0f, (float)textureY, 8, 8, 8, textureH, 64, 64, -1);
        if (player != null && player.isModelPartShown(PlayerModelPart.HAT)) {
            textureY = 8 + (upsideDown ? 8 : 0);
            textureH = 8 * (upsideDown ? -1 : 1);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skinTextureLocation, -4, -4, 40.0f, (float)textureY, 8, 8, 8, textureH, 64, 64, -1);
        }
    }
}

