/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.map.gui.TooltipButton;

public class GuiTexturedButton
extends TooltipButton {
    protected int textureX;
    protected int textureY;
    protected int textureW;
    protected int textureH;
    protected final int factorW;
    protected final int factorH;
    protected ResourceLocation texture;

    public GuiTexturedButton(int x, int y, int w, int h, int textureX, int textureY, int textureW, int textureH, ResourceLocation texture, Button.OnPress onPress, Supplier<Tooltip> tooltip, int factorW, int factorH) {
        super(x, y, w, h, (Component)Component.literal((String)""), onPress, tooltip);
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureW = textureW;
        this.textureH = textureH;
        this.texture = texture;
        this.factorW = factorW;
        this.factorH = factorH;
    }

    public Component getMessage() {
        if (this.tooltipSupplier != null) {
            return Component.literal((String)((Tooltip)this.tooltipSupplier.get()).getPlainText());
        }
        return super.getMessage();
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        int iconX = this.getX() + this.width / 2 - this.textureW / 2;
        int iconY = this.getY() + this.height / 2 - this.textureH / 2;
        int color = -12566464;
        if (this.active) {
            if (this.isHovered) {
                --iconY;
                color = -1644826;
            } else {
                color = -197380;
            }
        }
        if (this.isFocused()) {
            guiGraphics.fill(iconX, iconY, iconX + this.textureW, iconY + this.textureH, 0x55FFFFFF);
        }
        guiGraphics.blit(RenderType::guiTextured, this.texture, iconX, iconY, (float)this.textureX, (float)this.textureY, this.textureW, this.textureH, this.factorW, this.factorH, color);
    }
}

