/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import xaero.map.events.ClientEvents;

public class ClientEventsNeoForge
extends ClientEvents {
    @SubscribeEvent
    public void guiOpen(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setNewScreen(gui);
    }

    @SubscribeEvent
    public void renderTickPost(RenderFrameEvent.Post event) throws Exception {
        this.handleRenderTick(false);
    }

    @SubscribeEvent
    public void screenRenderPost(ScreenEvent.Render.Post event) {
        super.handleDrawScreen(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        super.handleWorldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return;
        }
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        if (gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void clientTickStart(ClientTickEvent.Pre event) throws Exception {
        super.handleClientTickStart();
    }
}

